/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import malik.emulator.time.CalendarSystem;

final class GregorianCalendarSystem
extends CalendarSystem {
    private static final long EPOCH_START = 62135596800000L;

    public boolean isLeapYear(int year) {
        if (year <= 0) {
            throw new IllegalArgumentException("CalendarSystem.isLeapYear: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 year \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        return year % (year % 100 == 0 ? 400 : 4) == 0;
    }

    public int computeNumberOfDays(int year, int month) {
        if (year <= 0) {
            throw new IllegalArgumentException("CalendarSystem.computeNumberOfDays: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 year \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (month < 1 || month-- > 12) {
            throw new IllegalArgumentException("CalendarSystem.computeNumberOfDays: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 month \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442 1 \u0434\u043e 12.");
        }
        return CalendarSystem.DAYS[this.isLeapYear(year) ? 1 : 0][month];
    }

    public int computeDayOfWeek(int year, int month, int day) {
        if (year <= 0) {
            throw new IllegalArgumentException("CalendarSystem.computeDayOfWeek: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 year \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("CalendarSystem.computeDayOfWeek: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 month \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442 1 \u0434\u043e 12.");
        }
        return (int)((this.computeTime(year, month, day, 0, 0, 0, 0, 0) + 62135596800000L) / 86400000L + 1L) % 7;
    }

    public long computeFields(long time, int offset) {
        byte daysPerMonth;
        long rem = (time += 62135596800000L + (long)offset) % 86400000L;
        int hour = (int)(rem / 3600000L);
        int minute = (int)((rem %= 3600000L) / 60000L);
        int millis = (int)(rem % 60000L);
        rem = time / 86400000L;
        int year = (int)(rem / 146097L * 400L);
        if ((rem %= 146097L) >= 146096L) {
            year += 399;
            rem = 365L;
        } else {
            year += (int)(rem / 36524L * 100L) + (int)((rem %= 36524L) / 1461L * 4L);
            if ((rem %= 1461L) >= 1460L) {
                year += 3;
                rem = 365L;
            } else {
                year += (int)(rem / 365L);
                rem %= 365L;
            }
        }
        byte[] months = CalendarSystem.DAYS[this.isLeapYear(++year) ? 1 : 0];
        int month = 0;
        while (rem >= (long)(daysPerMonth = months[month])) {
            rem -= (long)daysPerMonth;
            ++month;
        }
        int day = (int)rem + 1;
        return (long)year << 48 | (long)(++month) << 40 | (long)day << 32 | (long)hour << 24 | (long)minute << 16 | (long)millis;
    }

    public long computeTime(int year, int month, int day, int hour, int minute, int second, int millis, int offset) {
        if (year <= 0) {
            throw new IllegalArgumentException("CalendarSystem.computeTime: \u043f\u043e\u043b\u0435 year \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (month < 1 || month-- > 12) {
            throw new IllegalArgumentException("CalendarSystem.computeTime: \u043f\u043e\u043b\u0435 month \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442 1 \u0434\u043e 12.");
        }
        int leap = this.isLeapYear(year--) ? 1 : 0;
        long l = -62135596800000L + 12622780800000L * (long)(year / 400);
        year = year % 400;
        long result = l + 3155673600000L * (long)(year / 100) + 126230400000L * (long)((year %= 100) / 4) + 31536000000L * (long)(year % 4);
        byte[] months = CalendarSystem.DAYS[leap];
        int i = month;
        while (i-- > 0) {
            result += 86400000L * (long)months[i];
        }
        return result + 86400000L * (long)(day - 1) + 3600000L * (long)hour + 60000L * (long)minute + 1000L * (long)second + (long)millis - (long)offset;
    }

    public long epochStart() {
        return 62135596800000L;
    }
}

