/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.jpeg;

import java.io.DataInputStream;
import java.io.IOException;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.UnsupportedDataException;
import malik.emulator.fileformats.graphics.jpeg.Chunk;
import malik.emulator.fileformats.graphics.jpeg.Component;

final class ImageHeaderChunk
extends Chunk {
    public static final int BASELINE = 0;
    public static final int LOSSLESS = 3;
    public static final int SEQUENTIAL = 1;
    public static final int PROGRESSIVE = 2;
    public int width;
    public int height;
    public int horzBlocks;
    public int vertBlocks;
    public int maxHorzFactor;
    public int maxVertFactor;
    private byte[] componentsIds;
    private final Component[] components = new Component[256];

    public ImageHeaderChunk(int chunkName) {
        super(chunkName);
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        byte byte0;
        int iw;
        int chunkLen = Chunk.readSize((DataInputStream)stream);
        if (chunkLen < 9) {
            throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        stream.readByte();
        int ih = stream.readUnsignedShort();
        if (ih < 1 || (iw = stream.readUnsignedShort()) < 1) {
            throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        if ((long)iw * (long)ih > 0x100000L) {
            throw new UnsupportedDataException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
        }
        if (stream.readUnsignedByte() * 3 != (chunkLen -= 6)) {
            throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        if (chunkLen > 9) {
            throw new UnsupportedDataException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
        }
        byte[] componentData = new byte[chunkLen];
        stream.readFully(componentData);
        Component[] componentProps = this.components;
        int mvf = 0;
        int mhf = 0;
        int i = 1;
        while (i < chunkLen) {
            byte0 = componentData[i];
            int ihf = byte0 >> 4 & 0xF;
            int ivf = byte0 & 0xF;
            if (ihf * ivf == 0) {
                throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            if (mhf < ihf) {
                mhf = ihf;
            }
            if (mvf < ivf) {
                mvf = ivf;
            }
            i += 3;
        }
        int bw = mhf << 3;
        int bh = mvf << 3;
        int hb = (iw + bw - 1) / bw;
        int vb = (ih + bh - 1) / bh;
        i = 0;
        while (i < chunkLen) {
            int index = componentData[i++] & 0xFF;
            byte0 = componentData[i++];
            int ihf = byte0 >> 4 & 0xF;
            int ivf = byte0 & 0xF;
            int iqt = componentData[i++] & 0xF;
            componentProps[index] = new Component(ihf, ivf, iqt, hb * ihf, vb * ivf);
        }
        this.width = iw;
        this.height = ih;
        this.horzBlocks = hb;
        this.vertBlocks = vb;
        this.maxHorzFactor = mhf;
        this.maxVertFactor = mvf;
        this.componentsIds = componentData;
    }

    public boolean isDifferentialCoding() {
        return (this.chunkName & 4) != 0;
    }

    public boolean isArithmeticCoding() {
        return this.chunkName >= 65481;
    }

    public int getCodingType() {
        return this.chunkName & 3;
    }

    public int getComponentsCount() {
        return this.componentsIds.length / 3;
    }

    public int getComponentId(int index) {
        return this.componentsIds[index * 3] & 0xFF;
    }

    public Component getComponent(int componentId) {
        return this.components[componentId];
    }
}

