/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.jpeg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.graphics.jpeg.ChaffmanTable;
import malik.emulator.fileformats.graphics.jpeg.Component;
import malik.emulator.fileformats.graphics.jpeg.ImageHeaderChunk;
import malik.emulator.fileformats.graphics.jpeg.JPEGBitInputStream;
import malik.emulator.fileformats.graphics.jpeg.JPEGDecoder;
import malik.emulator.fileformats.graphics.jpeg.StartOfScanChunk;

final class ScanDecoder {
    private final boolean progressive;
    private int eobrun;
    private final int[] dcs;
    private StartOfScanChunk scan;
    private final InputStream source;
    private final JPEGBitInputStream stream;
    private final ImageHeaderChunk header;

    public ScanDecoder(InputStream stream, ImageHeaderChunk header) {
        this.progressive = header.getCodingType() == 2;
        this.dcs = new int[3];
        this.source = stream;
        this.stream = new JPEGBitInputStream(stream);
        this.header = header;
    }

    public void decodeScan(int restartInterval, StartOfScanChunk scan) throws IOException {
        if (this.progressive && !scan.isVeryProgressive()) {
            throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        this.stream.reset();
        this.scan = scan;
        ImageHeaderChunk header = this.header;
        int horzBlocks = header.horzBlocks;
        int vertBlocks = header.vertBlocks;
        Array.fill((int[])this.dcs, (int)0, (int)3, (int)0);
        int componentsCount = scan.getComponentsCount();
        if (componentsCount == 1) {
            Component component = header.getComponent(scan.getComponentId(0));
            int mcuWidth = (header.maxHorzFactor << 3) / component.horzFactor;
            int mcuHeight = (header.maxVertFactor << 3) / component.vertFactor;
            horzBlocks = (header.width + mcuWidth - 1) / mcuWidth;
            vertBlocks = (header.height + mcuHeight - 1) / mcuHeight;
        }
        boolean first = scan.approximateBitPositionHigh == 0;
        int spectralBegin = scan.spectralSelectionBegin;
        int spectralEnd = scan.spectralSelectionEnd;
        int approximateBit = scan.approximateBitPositionLow;
        int restartRemain = restartInterval;
        int ymcu = 0;
        while (ymcu < vertBlocks) {
            int xmcu = 0;
            while (xmcu < horzBlocks) {
                if (restartInterval != 0) {
                    if (restartRemain == 0) {
                        this.handleRestartInterval();
                        restartRemain = restartInterval;
                    }
                    --restartRemain;
                }
                this.decodeMCU(xmcu, ymcu, componentsCount, first, spectralBegin, spectralEnd, approximateBit);
                ++xmcu;
            }
            ++ymcu;
        }
    }

    private void decodeMCU(int xmcu, int ymcu, int componentsCount, boolean first, int begin, int end, int approximateBit) throws IOException {
        boolean progressive = this.progressive;
        ImageHeaderChunk header = this.header;
        StartOfScanChunk scan = this.scan;
        int componentIndex = 0;
        while (componentIndex < componentsCount) {
            int vf;
            int hf;
            Component component = header.getComponent(scan.getComponentId(componentIndex));
            int[] blocks = component.blocks;
            if (componentsCount == 1) {
                hf = 1;
                vf = 1;
            } else {
                hf = component.horzFactor;
                vf = component.vertFactor;
            }
            int v = 0;
            while (v < vf) {
                int h = 0;
                while (h < hf) {
                    int offset = component.getBlocksOffset(h + hf * xmcu, v + vf * ymcu);
                    if (!progressive) {
                        Array.fill((int[])blocks, (int)offset, (int)64, (int)0);
                    }
                    if (!progressive || scan.isDCProgressive()) {
                        this.decodeDCCoefficient(blocks, offset, component, componentIndex, first, approximateBit);
                    }
                    if (!progressive) {
                        this.decodeACCoefficients(blocks, offset, component);
                    } else if (scan.isACProgressive()) {
                        if (first) {
                            this.decodeACFirstCoefficients(blocks, offset, component, begin, end, approximateBit);
                        } else {
                            this.decodeACRefineCoefficients(blocks, offset, component, begin, end, approximateBit);
                        }
                    }
                    ++h;
                }
                ++v;
            }
            ++componentIndex;
        }
    }

    private void decodeACCoefficients(int[] blocks, int offset, Component component) throws IOException {
        byte[] order = JPEGDecoder.ORDER_ZIGZAG_INVERTED;
        ChaffmanTable table = component.chaffmanTableAC;
        JPEGBitInputStream stream = this.stream;
        int k = 1;
        while (k < 64) {
            int rs = table.readValue(stream);
            int s = rs & 0xF;
            int r = rs >> 4;
            if (s == 0) {
                if (r != 15) break;
                k += 16;
                continue;
            }
            int bits = stream.readAndExtend(s);
            blocks[offset + order[k += r]] = bits;
            ++k;
        }
    }

    private void decodeACFirstCoefficients(int[] blocks, int offset, Component component, int begin, int end, int approximateBit) throws IOException {
        int eobrun = this.eobrun;
        if (eobrun > 0) {
            this.eobrun = eobrun - 1;
            return;
        }
        byte[] order = JPEGDecoder.ORDER_ZIGZAG_INVERTED;
        ChaffmanTable table = component.chaffmanTableAC;
        JPEGBitInputStream stream = this.stream;
        int k = begin;
        while (k <= end) {
            int rs = table.readValue(stream);
            int s = rs & 0xF;
            int r = rs >> 4;
            if (s == 0) {
                if (r == 15) {
                    k += 16;
                    continue;
                }
                this.eobrun = (1 << r) + stream.readBits(r) - 1;
                break;
            }
            int bits = stream.readAndExtend(s);
            blocks[offset + order[k += r]] = bits << approximateBit;
            ++k;
        }
    }

    private void decodeACRefineCoefficients(int[] blocks, int offset, Component component, int begin, int end, int approximateBit) throws IOException {
        int eobrun = this.eobrun;
        byte[] order = JPEGDecoder.ORDER_ZIGZAG_INVERTED;
        ChaffmanTable table = component.chaffmanTableAC;
        JPEGBitInputStream stream = this.stream;
        int k = begin;
        while (k <= end) {
            int index;
            if (eobrun > 0) {
                while (k <= end) {
                    int index2 = offset + order[k];
                    blocks[index2] = stream.refineAC(blocks[index2], approximateBit);
                    ++k;
                }
                --eobrun;
                continue;
            }
            int rs = table.readValue(stream);
            int s = rs & 0xF;
            int r = rs >> 4;
            if (s == 0) {
                if (r == 15) {
                    int zeros = 0;
                    while (zeros < 16 && k <= end) {
                        index = offset + order[k];
                        if (blocks[index] != 0) {
                            blocks[index] = stream.refineAC(blocks[index], approximateBit);
                        } else {
                            ++zeros;
                        }
                        ++k;
                    }
                    continue;
                }
                eobrun = (1 << r) + stream.readBits(r);
                continue;
            }
            int bits = stream.readBits(s);
            index = offset + order[k];
            int zeros = 0;
            while ((zeros < r || blocks[index] != 0) && k <= end) {
                if (blocks[index] != 0) {
                    blocks[index] = stream.refineAC(blocks[index], approximateBit);
                } else {
                    ++zeros;
                }
                index = offset + order[++k];
            }
            blocks[index] = (bits != 0 ? 1 : -1) << approximateBit;
            ++k;
        }
        this.eobrun = eobrun;
    }

    private void decodeDCCoefficient(int[] blocks, int offset, Component component, int componentIndex, boolean first, int approximateBit) throws IOException {
        boolean progressive = this.progressive;
        int dc = 0;
        ChaffmanTable table = component.chaffmanTableDC;
        if (progressive && !first) {
            int bit = this.stream.readBit();
            dc = blocks[offset] + (bit << approximateBit);
        } else {
            JPEGBitInputStream stream = this.stream;
            int[] dcs = this.dcs;
            dc = this.dcs[componentIndex];
            int q = table.readValue(stream);
            if (q != 0) {
                int diff = stream.readAndExtend(q);
                dcs[componentIndex] = dc += diff;
            }
            if (!progressive) {
                dc <<= approximateBit;
            }
        }
        blocks[offset] = dc;
    }

    private void handleRestartInterval() throws IOException {
        int byte0;
        InputStream source = this.source;
        do {
            if ((byte0 = source.read()) >= 0) continue;
            throw new EOFException("DataInputStream.readUnsignedByte: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        } while (byte0 != 255);
        do {
            if ((byte0 = source.read()) >= 0) continue;
            throw new EOFException("DataInputStream.readUnsignedByte: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        } while (byte0 == 255);
        int chunkName = 0xFF00 | byte0;
        if (chunkName < 65488 || chunkName > 65495) {
            throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        this.eobrun = 0;
        this.stream.reset();
        Array.fill((int[])this.dcs, (int)0, (int)3, (int)0);
    }
}

