/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.png;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import malik.emulator.compression.zlib.Zlib;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.UnsupportedDataException;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.fileformats.graphics.png.DecodeAdam7;
import malik.emulator.fileformats.graphics.png.DecodeMethod;
import malik.emulator.fileformats.graphics.png.DecodeNormal;
import malik.emulator.fileformats.graphics.png.Unwrap16bitPC;
import malik.emulator.fileformats.graphics.png.Unwrap1bitPC;
import malik.emulator.fileformats.graphics.png.Unwrap1bitPP;
import malik.emulator.fileformats.graphics.png.Unwrap2bitPC;
import malik.emulator.fileformats.graphics.png.Unwrap2bitPP;
import malik.emulator.fileformats.graphics.png.Unwrap4bitPC;
import malik.emulator.fileformats.graphics.png.Unwrap4bitPP;
import malik.emulator.fileformats.graphics.png.Unwrap8bitPC;
import malik.emulator.fileformats.graphics.png.UnwrapMethod;

public final class PNGDecoder
implements ImageDecoder {
    public static final long SIGNATURE = -8552249625308161526L;
    private static final int IHDR = 1229472850;
    private static final int GAMA = 1732332865;
    private static final int PLTE = 1347179589;
    private static final int TRNS = 1951551059;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private int width;
    private int height;
    private int[] pixels;

    static int decodeNormal(byte[] stream, int offset, int pixelType, int bitDepth, int components, byte[] imageData, int imageWidth, int imageHeight, UnwrapMethod method) {
        int k = PNGDecoder.getLineSize(pixelType, bitDepth, components, imageWidth);
        int f = PNGDecoder.getFilterSize(pixelType, bitDepth, components);
        int total = imageWidth * components;
        int lineSize = k++;
        int ofs = 0;
        int i = 0;
        while (i < imageHeight) {
            switch (stream[offset++]) {
                default: {
                    break;
                }
                case 1: {
                    int lim = offset + lineSize;
                    int j = offset + f;
                    while (j < lim) {
                        stream[j] = (byte)(stream[j] + stream[j - f]);
                        ++j;
                    }
                    break;
                }
                case 2: {
                    if (i <= 0) break;
                    int lim = offset + lineSize;
                    int j = offset;
                    while (j < lim) {
                        stream[j] = (byte)(stream[j] + stream[j - k]);
                        ++j;
                    }
                    break;
                }
                case 3: {
                    int j;
                    int lim;
                    if (i > 0) {
                        lim = offset + f;
                        j = offset;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + ((stream[j - k] & 0xFF) >> 1));
                            ++j;
                        }
                        lim = offset + lineSize;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + ((stream[j - k] & 0xFF) + (stream[j - f] & 0xFF) >> 1));
                            ++j;
                        }
                    } else {
                        lim = offset + lineSize;
                        j = offset + f;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + ((stream[j - f] & 0xFF) >> 1));
                            ++j;
                        }
                    }
                    break;
                }
                case 4: {
                    int j;
                    int lim;
                    if (i > 0) {
                        lim = offset + f;
                        j = offset;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + PNGDecoder.paethPredictor(0, stream[j - k] & 0xFF, 0));
                            ++j;
                        }
                        lim = offset + lineSize;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + PNGDecoder.paethPredictor(stream[j - f] & 0xFF, stream[j - k] & 0xFF, stream[j - f - k] & 0xFF));
                            ++j;
                        }
                    } else {
                        lim = offset + lineSize;
                        j = offset + f;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + PNGDecoder.paethPredictor(stream[j - f] & 0xFF, 0, 0));
                            ++j;
                        }
                        break block0;
                    }
                }
            }
            method.unwrap(stream, offset, imageData, ofs, total);
            offset += lineSize;
            ofs += total;
            ++i;
        }
        return offset;
    }

    static int decodeAdam7(byte[] stream, int offset, int pixelType, int bitDepth, int components, byte[] imageData, int imageWidth, int imageHeight, UnwrapMethod method) {
        int[] interlacing = new int[]{274, 4130, 548, 8260, 1096, 16520, 136};
        int i = interlacing.length;
        while (i-- > 0) {
            int current = interlacing[i];
            int xstart = current >> 12;
            int ystart = current >> 8 & 0xF;
            int xinc = current >> 4 & 0xF;
            int yinc = current & 0xF;
            int width = (imageWidth - xstart + xinc - 1) / xinc;
            int height = (imageHeight - ystart + yinc - 1) / yinc;
            byte[] data = new byte[width * height * components];
            offset = PNGDecoder.decodeNormal(stream, offset, pixelType, bitDepth, components, data, width, height, method);
            int y0 = 0;
            int y = ystart;
            while (y < imageHeight) {
                int x0 = 0;
                int x = xstart;
                while (x < imageWidth) {
                    Array.copy((byte[])data, (int)((y0 * width + x0) * components), (byte[])imageData, (int)((y * imageWidth + x) * components), (int)components);
                    ++x0;
                    x += xinc;
                }
                ++y0;
                y += yinc;
            }
        }
        return offset;
    }

    private static void copy(InputStream input, OutputStream output, long count) throws IOException {
        int remainder = (int)count & 0xFFFF;
        long fragments = count >> 16;
        byte[] buffer = new byte[65536];
        int i = 0;
        while ((long)i < fragments) {
            output.write(buffer, 0, input.read(buffer));
            ++i;
        }
        if (remainder > 0) {
            output.write(buffer, 0, input.read(buffer, 0, remainder));
        }
    }

    private static double power(double base, double exponent) {
        return base > 0.0 ? Math.pow2((double)(exponent * Math.log2((double)base))) : 0.0;
    }

    private static int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        return pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
    }

    private static int readPixel(byte[] data, int offset, int[] gamma, int[] palette, boolean useAlpha, boolean usePalette, boolean useGrayscale) {
        int b;
        int g;
        int r;
        int a;
        if (usePalette) {
            int p = palette[data[offset] & 0xFF];
            a = p >> 24;
            r = p >> 16;
            g = p >> 8;
            b = p;
        } else if (useAlpha) {
            if (useGrayscale) {
                g = b = data[offset];
                r = b;
                a = data[offset + 1];
            } else {
                r = data[offset];
                g = data[offset + 1];
                b = data[offset + 2];
                a = data[offset + 3];
            }
        } else {
            if (useGrayscale) {
                g = b = data[offset];
                r = b;
            } else {
                r = data[offset];
                g = data[offset + 1];
                b = data[offset + 2];
            }
            a = 255;
        }
        return a << 24 | gamma[r & 0xFF] << 16 | gamma[g & 0xFF] << 8 | gamma[b & 0xFF];
    }

    private static int getLineSize(int pixelType, int bitDepth, int components, int imageWidth) {
        return (pixelType == 0 || pixelType == 3 ? bitDepth * imageWidth + 7 : bitDepth * imageWidth * components) >> 3;
    }

    private static int getFilterSize(int pixelType, int bitDepth, int components) {
        return (pixelType == 0 || pixelType == 3 ? (bitDepth < 16 ? 8 : 16) : bitDepth * components) >> 3;
    }

    public void loadFromInputStream(InputStream stream) throws IOException {
        this.loadFromDataStream(new ExtendedDataInputStream(stream));
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        int chunkName;
        boolean useAlpha = false;
        boolean usePalette = false;
        boolean useGrayscale = false;
        boolean dataHandled = false;
        boolean gammaHandled = false;
        boolean headerHandled = false;
        boolean paletteHandled = false;
        boolean transparencyHandled = false;
        int bitDepth = 0;
        int pixelType = 0;
        int components = 0;
        int imageWidth = 0;
        int imageHeight = 0;
        byte[] imageData = null;
        int[] imageGamma = new int[256];
        int[] imagePixels = null;
        int[] imagePalette = null;
        DecodeMethod dmethod = null;
        UnwrapMethod umethod = null;
        ByteArrayOutputStream compressedData = null;
        int i = 256;
        while (i-- > 0) {
            imageGamma[i] = i;
        }
        do {
            int chunkSize = stream.readInt();
            chunkName = stream.readInt();
            switch (chunkName) {
                default: {
                    stream.skip((long)chunkSize & 0xFFFFFFFFL);
                    break;
                }
                case 1229472850: {
                    int h;
                    if (headerHandled || chunkSize != 13) {
                        throw new InvalidDataFormatException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    int w = stream.readInt();
                    long area = ((long)w & 0xFFFFFFFFL) * ((long)(h = stream.readInt()) & 0xFFFFFFFFL);
                    if (area <= 0L || area > 0x100000L) {
                        throw new UnsupportedDataException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
                    }
                    int bd = stream.readUnsignedByte();
                    int pt = stream.readUnsignedByte();
                    if ((pt != 0 || bd != 1 && bd != 2 && bd != 4 && bd != 8 && bd != 16) && (pt != 3 || bd != 1 && bd != 2 && bd != 4 && bd != 8) && (pt != 2 && pt != 4 && pt != 6 || bd != 8 && bd != 16)) {
                        throw new InvalidDataFormatException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    int cm = stream.readUnsignedByte();
                    int fm = stream.readUnsignedByte();
                    int mm = stream.readUnsignedByte();
                    if (cm != 0 || fm != 0 || mm < 0 || mm > 1) {
                        throw new InvalidDataFormatException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    useAlpha = pt == 4 || pt == 6;
                    usePalette = pt == 3;
                    useGrayscale = pt == 0 || pt == 4;
                    bitDepth = bd;
                    pixelType = pt;
                    components = pt == 6 ? 4 : (pt == 2 ? 3 : (pt == 4 ? 2 : 1));
                    imageWidth = w;
                    imageHeight = h;
                    imagePixels = new int[w * h];
                    imagePalette = usePalette ? new int[256] : null;
                    DecodeMethod decodeMethod = dmethod = mm == 0 ? new DecodeNormal() : new DecodeAdam7();
                    if (usePalette) {
                        switch (bitDepth) {
                            default: {
                                break;
                            }
                            case 1: {
                                umethod = new Unwrap1bitPP();
                                break;
                            }
                            case 2: {
                                umethod = new Unwrap2bitPP();
                                break;
                            }
                            case 4: {
                                umethod = new Unwrap4bitPP();
                                break;
                            }
                            case 8: {
                                umethod = new Unwrap8bitPC();
                                break;
                            }
                        }
                    } else {
                        switch (bitDepth) {
                            default: {
                                break;
                            }
                            case 1: {
                                umethod = new Unwrap1bitPC();
                                break;
                            }
                            case 2: {
                                umethod = new Unwrap2bitPC();
                                break;
                            }
                            case 4: {
                                umethod = new Unwrap4bitPC();
                                break;
                            }
                            case 8: {
                                umethod = new Unwrap8bitPC();
                                break;
                            }
                            case 16: {
                                umethod = new Unwrap16bitPC();
                            }
                        }
                    }
                    headerHandled = true;
                    break;
                }
                case 1732332865: {
                    if (!headerHandled || gammaHandled || chunkSize != 4) {
                        throw new InvalidDataFormatException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    double exponent = 100000.0 / (2.2 * (double)stream.readInt());
                    int i2 = 256;
                    while (i2-- > 0) {
                        imageGamma[i2] = (int)Math.round(255.0 * PNGDecoder.power((double)i2 / 255.0, exponent));
                    }
                    gammaHandled = true;
                    break;
                }
                case 1347179589: {
                    if (!headerHandled || paletteHandled || chunkSize < 0 || chunkSize > 768 || chunkSize % 3 != 0 || !usePalette) {
                        throw new InvalidDataFormatException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    int len = chunkSize / 3;
                    int i3 = 0;
                    while (i3 < len) {
                        int r = stream.readUnsignedByte();
                        int g = stream.readUnsignedByte();
                        int b = stream.readUnsignedByte();
                        imagePalette[i3] = 0xFF000000 | r << 16 | g << 8 | b;
                        ++i3;
                    }
                    paletteHandled = true;
                    break;
                }
                case 1951551059: {
                    if (!headerHandled || transparencyHandled || chunkSize < 0 || chunkSize > 256) {
                        throw new InvalidDataFormatException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    if (usePalette) {
                        int i4 = 0;
                        while (i4 < chunkSize) {
                            imagePalette[i4] = imagePalette[i4] & 0xFFFFFF | stream.readUnsignedByte() << 24;
                            ++i4;
                        }
                    } else {
                        stream.skip((long)chunkSize & 0xFFFFFFFFL);
                    }
                    transparencyHandled = true;
                    break;
                }
                case 1229209940: {
                    if (!headerHandled || chunkSize < 0) {
                        throw new InvalidDataFormatException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    PNGDecoder.copy((InputStream)stream, compressedData == null ? new ByteArrayOutputStream() : compressedData, chunkSize);
                    dataHandled = true;
                    break;
                }
                case 1229278788: {
                    if (!headerHandled || !dataHandled || chunkSize != 0 || compressedData == null) {
                        throw new InvalidDataFormatException("PNGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    int length = imageWidth * imageHeight * components;
                    byte[] rawData = Zlib.decompress(compressedData.toByteArray());
                    imageData = new byte[length];
                    dmethod.decode(rawData, 0, pixelType, bitDepth, components, imageData, imageWidth, imageHeight, umethod);
                }
            }
            stream.skip(4L);
        } while (chunkName != 1229278788);
        int len = imagePixels.length;
        int offset = 0;
        int i5 = 0;
        while (i5 < len) {
            imagePixels[i5] = PNGDecoder.readPixel(imageData, offset, imageGamma, imagePalette, useAlpha, usePalette, useGrayscale);
            offset += components;
            ++i5;
        }
        this.width = imageWidth;
        this.height = imageHeight;
        this.pixels = imagePixels;
    }

    public void clear() {
        this.width = 0;
        this.height = 0;
        this.pixels = null;
    }

    public boolean isEmpty() {
        return (this.width | this.height) == 0 && this.pixels == null;
    }

    public boolean alphaSupported() {
        return true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getPixels() {
        int[] result = this.pixels;
        if (this.pixels == null) {
            return null;
        }
        int[] nArray = result;
        int len = result.length;
        result = new int[len];
        Array.copy((int[])nArray, (int)0, (int[])result, (int)0, (int)len);
        return result;
    }
}

