/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.TextOutput;
import malik.emulator.media.graphics.RasterCanvas;

public class Gauge
extends Item {
    public static final int INDEFINITE = -1;
    public static final int CONTINUOUS_IDLE = 0;
    public static final int INCREMENTAL_IDLE = 1;
    public static final int CONTINUOUS_RUNNING = 2;
    public static final int INCREMENTAL_UPDATING = 3;
    private static final int TRACK_HEIGHT;
    private static final int THUMB_WIDTH;
    private static final int THUMB_HEIGHT;
    private static final Font FONT;
    private boolean controlFocused;
    private boolean sliderFocused;
    private boolean interactive;
    private boolean newInput;
    private boolean pressed;
    private int contentWidth;
    private int argument;
    private long fields;
    private TextOutput output;

    static {
        int c = RasterCanvas.getElementOfGUISizes((int)11, (int)0, (int)0);
        int b = RasterCanvas.getElementOfGUISizes((int)11, (int)3, (int)0) >> 16;
        TRACK_HEIGHT = b == -1 ? 8 : b;
        short s = (short)c;
        b = s;
        THUMB_WIDTH = s == -1 ? 8 : b;
        b = c >> 16;
        THUMB_HEIGHT = b == -1 ? 16 : b;
        FONT = Font.getFont(0, 0, 8);
    }

    public Gauge(String label, boolean interactive, int maximum, int position) {
        this(0, -1, -1, label, null, null, null, interactive, maximum, position);
    }

    public Gauge(int layout, int lockedWidth, int lockedHeight, String label, Command[] commands, Command defaultCommand, ItemCommandListener listener, boolean interactive, int maximum, int position) {
        super(layout, lockedWidth, lockedHeight, label, commands, defaultCommand, listener);
        boolean f;
        boolean bl = f = interactive || maximum != -1;
        if (bl ? maximum <= 0 : position < 0 || position > 3) {
            throw new IllegalArgumentException("Gauge: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u043b\u043e\u0441\u044b \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0430.");
        }
        if (f) {
            position = position < 0 ? 0 : (position > maximum ? maximum : position);
        }
        this.interactive = interactive;
        this.newInput = true;
        this.fields = (long)maximum << 32 | (long)position;
        this.output = interactive ? new TextOutput(23) : null;
    }

    public void setMaxValue(int maximum) {
        long fields = this.fields;
        int position = (int)fields;
        int current = (int)(fields >> 32);
        if (this.interactive) {
            if (maximum <= 0) {
                throw new IllegalArgumentException("Gauge.setMaxValue: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 maximum \u0434\u043b\u044f \u0438\u043d\u0442\u0435\u0440\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439 \u043f\u043e\u043b\u043e\u0441\u044b \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
            }
        } else {
            if (maximum <= 0 && maximum != -1) {
                throw new IllegalArgumentException("Gauge.setMaxValue: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 maximum \u0434\u043b\u044f \u043d\u0435\u0438\u043d\u0442\u0435\u0440\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439 \u043f\u043e\u043b\u043e\u0441\u044b \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u044f\u0442\u044c\u0441\u044f \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u043c\u0443 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044e INDEFINITE.");
            }
            if (current > 0 && maximum == -1) {
                this.setFields(-1, 0);
                this.notifyPaint();
                return;
            }
            if (current == -1) {
                if (maximum > 0) {
                    if (this.isVisible() && position == 2) {
                        this.stopUpdating();
                    }
                    this.setFields(maximum, 0);
                    this.notifyPaint();
                }
                return;
            }
        }
        boolean needPaint = false;
        if (position > maximum) {
            needPaint = true;
            position = maximum;
        }
        if (current != maximum || needPaint) {
            this.setFields(maximum, position);
            this.notifyPaint();
        }
    }

    public void setValue(int position) {
        long fields = this.fields;
        int current = (int)fields;
        int maximum = (int)(fields >> 32);
        if (this.interactive || maximum != -1) {
            position = position < 0 ? 0 : (position > maximum ? maximum : position);
        } else if (position < 0 || position > 3) {
            throw new IllegalArgumentException("Gauge.setValue: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 position \u0434\u043b\u044f \u043d\u0435\u0438\u043d\u0442\u0435\u0440\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439 \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0439 \u043f\u043e\u043b\u043e\u0441\u044b \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0430.");
        }
        if (current != position) {
            if (this.isVisible() && maximum == -1) {
                if (position == 2) {
                    this.startUpdating();
                } else {
                    this.stopUpdating();
                }
            }
            this.setFields(maximum, position);
            this.notifyPaint();
        }
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public int getMaxValue() {
        return (int)(this.fields >> 32);
    }

    public int getValue() {
        return (int)this.fields;
    }

    void paintContent(Graphics render, int contentWidth, int contentHeight) {
        boolean focused = this.controlFocused;
        long fields = this.fields;
        int position = (int)fields;
        int maximum = (int)(fields >> 32);
        if (this.interactive) {
            TextOutput output = this.output;
            output.clear();
            output.append(position, 10, true);
            output.append(" / ");
            output.append(maximum, 10, true);
            char[] chars = output.getChars();
            int len = output.getLength();
            render.drawElementOfGUI(11, 3, focused ? 1 : 0, THUMB_WIDTH / 2 - 1, (THUMB_HEIGHT - TRACK_HEIGHT) / 2, contentWidth - THUMB_WIDTH + 2, TRACK_HEIGHT);
            render.drawElementOfGUI(11, 0, focused ? (this.pressed ? 1 : 3) : 0, (int)((long)position * (long)(contentWidth - THUMB_WIDTH) / (long)maximum), 0, THUMB_WIDTH, THUMB_HEIGHT);
            render.setFont(FONT);
            render.setColor(RasterCanvas.getSystemColor((int)40));
            render.drawChars(chars, 0, len, Math.max(contentWidth - FONT.charsWidth(chars, 0, len), 0), THUMB_HEIGHT, 20);
            return;
        }
        if (maximum > 0) {
            render.drawElementOfGUI(9, 0, 0, 0, 0, contentWidth, contentHeight);
            render.drawElementOfGUI(9, 1, 0, 2, 2, (int)((long)position * (long)(contentWidth - 4) / (long)maximum), contentHeight - 4);
            return;
        }
        switch (position) {
            default: {
                return;
            }
            case 0: 
            case 1: {
                double dtw = 0.14285714285714285 * (double)(contentWidth - 4);
                int itw = (int)dtw;
                render.drawElementOfGUI(9, 0, 0, 0, 0, contentWidth, contentHeight);
                int i = 1;
                while (i < 7) {
                    render.drawElementOfGUI(9, 1, 0, (int)(dtw * (double)i) + 2, 2, itw, contentHeight - 4);
                    i += 2;
                }
                return;
            }
            case 2: {
                int itw = (contentWidth - 4) / 5;
                render.drawElementOfGUI(9, 0, 0, 0, 0, contentWidth, contentHeight);
                render.drawElementOfGUI(9, 1, 0, (int)Math.round(0.5 * (double)(contentWidth - itw - 4) * (1.0 + Math.sin(0.19634954084936207 * (double)this.argument))) + 2, 2, itw, contentHeight - 4);
                return;
            }
            case 3: 
        }
        int itw = (contentWidth - 4) / 5;
        render.drawElementOfGUI(9, 0, 0, 0, 0, contentWidth, contentHeight);
        render.drawElementOfGUI(9, 1, 0, (contentWidth - itw - 4) / 2 + 2, 2, itw, contentHeight - 4);
    }

    void onUpdate() {
        this.argument = this.argument + 1 & 0x1F;
    }

    void onShow() {
        if (this.fields == -4294967294L) {
            this.startUpdating();
        }
    }

    void onHide() {
        if (this.fields == -4294967294L) {
            this.stopUpdating();
        }
    }

    void onSizeChanged(int contentWidth, int contentHeight) {
        this.contentWidth = contentWidth;
    }

    void onKeyPressed(int key, int charCode) {
        this.keyHandle(key);
    }

    void onKeyRepeated(int key, int charCode) {
        this.keyHandle(key);
    }

    void onContentPointerPressed(int x, int y, int button) {
        if (!this.interactive || button != 0) {
            return;
        }
        if (y < THUMB_HEIGHT) {
            int newPos;
            long fields = this.fields;
            int position = (int)fields;
            int maximum = (int)(fields >> 32);
            this.newInput = true;
            int l = (int)((long)position * (long)(this.contentWidth - THUMB_WIDTH) / (long)maximum);
            if (x >= l + THUMB_WIDTH) {
                newPos = position + (maximum < 10 ? 1 : maximum / 10);
                if (newPos < 0) {
                    newPos = 0;
                } else if (newPos > maximum) {
                    newPos = maximum;
                }
            } else if (x < l) {
                newPos = position - (maximum < 10 ? 1 : maximum / 10);
                if (newPos < 0) {
                    newPos = 0;
                } else if (newPos > maximum) {
                    newPos = maximum;
                }
            } else {
                this.pressed = true;
                this.notifyPaint();
                return;
            }
            if (newPos != position) {
                this.setFields(maximum, newPos);
                this.notifyPaint();
                super.notifyStateChanged();
            }
        }
    }

    void onContentPointerDragged(int x, int y) {
        int w;
        if (!this.interactive || !this.pressed || (w = this.contentWidth - THUMB_WIDTH) <= 0) {
            return;
        }
        long fields = this.fields;
        int position = (int)fields;
        int maximum = (int)(fields >> 32);
        this.newInput = true;
        int newPos = (int)((long)(x - THUMB_WIDTH / 2) * (long)maximum / (long)w);
        if (newPos < 0) {
            newPos = 0;
        } else if (newPos > maximum) {
            newPos = maximum;
        }
        if (newPos != position) {
            this.setFields(maximum, newPos);
            this.notifyPaint();
            super.notifyStateChanged();
        }
    }

    void onContentPointerReleased(int x, int y, int button) {
        int w;
        if (!this.interactive || !this.pressed || button != 0 || (w = this.contentWidth - THUMB_WIDTH) <= 0) {
            return;
        }
        long fields = this.fields;
        int position = (int)fields;
        int maximum = (int)(fields >> 32);
        this.newInput = true;
        this.pressed = false;
        int newPos = (int)((long)(x - THUMB_WIDTH / 2) * (long)maximum / (long)w);
        if (newPos < 0) {
            newPos = 0;
        } else if (newPos > maximum) {
            newPos = maximum;
        }
        this.setFields(maximum, newPos);
        this.notifyPaint();
        if (newPos != position) {
            super.notifyStateChanged();
        }
    }

    void onTraverseOut() {
        if (!this.interactive) {
            return;
        }
        this.controlFocused = false;
        this.pressed = false;
        this.notifyPaint();
    }

    boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        if (!this.interactive) {
            return false;
        }
        boolean cfocused = this.controlFocused;
        this.controlFocused = true;
        if (!cfocused) {
            this.newInput = true;
            this.notifyPaint();
        }
        if (this.sliderFocused) {
            return true;
        }
        switch (direction) {
            case 2: {
                if (cfocused) {
                    long fields = this.fields;
                    int position = (int)fields;
                    int maximum = (int)(fields >> 32);
                    this.newInput = true;
                    if (position > 0) {
                        this.setFields(maximum, position - 1);
                        this.notifyPaint();
                        super.notifyStateChanged();
                    }
                }
                return true;
            }
            case 5: {
                if (cfocused) {
                    long fields = this.fields;
                    int position = (int)fields;
                    int maximum = (int)(fields >> 32);
                    this.newInput = true;
                    if (position < maximum) {
                        this.setFields(maximum, position + 1);
                        this.notifyPaint();
                        super.notifyStateChanged();
                    }
                }
                return true;
            }
            case 1: 
            case 6: {
                return !cfocused;
            }
        }
        return true;
    }

    boolean keyHandling(int key) {
        int keyCode = MIDletProxy.getInstance().getKeyCode(key);
        return keyCode >= 48 && keyCode <= 57;
    }

    boolean isMatchForAlert() {
        return !this.interactive && super.isMatchForAlert();
    }

    int getPreferredContentWidth(int contentHeight, int containerClientWidth) {
        return containerClientWidth;
    }

    int getPreferredContentHeight(int contentWidth) {
        return this.interactive ? FONT.getHeight() + THUMB_HEIGHT : 16;
    }

    private void setFields(int maximum, int position) {
        this.fields = (long)maximum << 32 | (long)position;
    }

    private void keyHandle(int key) {
        if (!this.interactive) {
            return;
        }
        int keyCode = MIDletProxy.getInstance().getKeyCode(key);
        if (keyCode >= 48 && keyCode <= 57) {
            int maximum;
            int digit = keyCode - 48;
            long fields = this.fields;
            int position = (int)fields;
            int newPos = this.newInput ? digit : 10 * position + digit;
            if (newPos >= (maximum = (int)(fields >> 32)) || newPos < 0) {
                newPos = maximum;
                this.newInput = true;
            } else {
                this.newInput = false;
            }
            if (newPos != position) {
                this.setFields(maximum, newPos);
                this.notifyPaint();
                super.notifyStateChanged();
            }
        }
    }
}

