/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import malik.emulator.media.graphics.RasterCanvas;

public class ImageItem
extends Item {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    private boolean controlFocused;
    private boolean pointerFocused;
    private boolean pointerPressed;
    private int contentWidth;
    private int contentHeight;
    private int appearance;
    private Image image;
    private String altText;

    public ImageItem(String label, Image image, int layout, String altText) {
        this(layout, label, null, null, null, image, altText, 0);
    }

    public ImageItem(String label, Image image, int layout, String altText, int appearance) {
        this(layout, label, null, null, null, image, altText, appearance);
    }

    public ImageItem(int layout, String label, Command[] commands, Command defaultCommand, ItemCommandListener listener, Image image, String altText, int appearance) {
        super(layout, -1, -1, label, commands, defaultCommand, listener);
        if (appearance != 0 && appearance != 1 && appearance != 2) {
            throw new IllegalArgumentException("ImageItem: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 appearance.");
        }
        this.appearance = appearance;
        this.image = image != null ? Image.createImage(image) : null;
        this.altText = altText;
    }

    public void setLayout(int layout) {
        super.setLayout(layout);
    }

    public int getLayout() {
        return super.getLayout();
    }

    public void setImage(Image image) {
        this.image = image != null ? Image.createImage(image) : null;
        this.notifyUpdate();
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public int getAppearanceMode() {
        return this.appearance;
    }

    public Image getImage() {
        return this.image;
    }

    public String getAltText() {
        return this.altText;
    }

    void paintContent(Graphics render, int contentWidth, int contentHeight) {
        int a;
        int t;
        int l;
        Image image = this.image;
        if (image == null) {
            return;
        }
        boolean pressed = this.pointerPressed;
        int w = image.getWidth();
        int h = image.getHeight();
        if (this.isMatchForButton()) {
            render.drawElementOfGUI(4, pressed ? 1 : (this.controlFocused ? 3 : 0), 0, 0, 0, contentWidth, contentHeight);
            l = (contentWidth - w) / 2 + (pressed ? 1 : 0);
            t = (contentHeight - h) / 2 + (pressed ? 1 : 0);
            a = 20;
        } else if (this.isMatchForHyperlink()) {
            a = pressed ? 1 : (this.controlFocused ? 3 : 0);
            render.setColor(RasterCanvas.getSystemColor((int)(a + 36)));
            render.drawRect(0, 0, contentWidth - 1, contentHeight - 1);
            render.drawRect(1, 1, contentWidth - 3, contentHeight - 3);
            l = (contentWidth - w) / 2 + (pressed ? 1 : 0);
            t = (contentHeight - h) / 2 + (pressed ? 1 : 0);
            a = 20;
        } else {
            l = pressed ? 5 : 4;
            t = pressed ? 5 : 4;
            a = 20;
        }
        render.drawImage(image, l, t, a);
    }

    void onSizeChanged(int contentWidth, int contentHeight) {
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
    }

    void onContentPointerPressed(int x, int y, int button) {
        if (button != 0 || !this.isMatchForButton() && !this.isMatchForHyperlink()) {
            return;
        }
        this.pointerFocused = true;
        this.pointerPressed = true;
        this.notifyPaint();
    }

    void onContentPointerDragged(int x, int y) {
        if (!this.pointerFocused || this.pointerPressed == (this.pointerPressed = x >= 0 && x < this.contentWidth && y >= 0 && y < this.contentHeight)) {
            return;
        }
        this.notifyPaint();
    }

    void onContentPointerReleased(int x, int y, int button) {
        if (button != 0) {
            return;
        }
        boolean pressed = this.pointerPressed;
        this.pointerFocused = false;
        this.pointerPressed = false;
        if (!pressed) {
            return;
        }
        this.notifyPaint();
        this.notifyCommandAction(this.getCommands().getDefaultCommand());
    }

    void onTraverseOut() {
        this.controlFocused = false;
        if (this.isMatchForButton()) {
            this.notifyPaint();
        }
    }

    boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        boolean cfocused = this.controlFocused;
        this.controlFocused = true;
        if (!cfocused && this.isMatchForButton()) {
            this.notifyPaint();
        }
        if (this.pointerFocused) {
            return true;
        }
        switch (direction) {
            case 1: {
                if (!cfocused) break;
                int tmp = visibleRectangle[1];
                if (tmp > 0) {
                    visibleRectangle[1] = Math.max(tmp - viewportHeight / 4, 0);
                    return true;
                }
                return false;
            }
            case 2: {
                if (!cfocused) break;
                int tmp = visibleRectangle[0];
                if (tmp > 0) {
                    visibleRectangle[0] = Math.max(tmp - viewportWidth / 4, 0);
                    return true;
                }
                return false;
            }
            case 5: {
                int size = super.getPreferredWidth() - visibleRectangle[2];
                if (!cfocused) break;
                int tmp = visibleRectangle[0];
                if (tmp < size) {
                    visibleRectangle[0] = Math.min(tmp + viewportWidth / 4, size);
                    return true;
                }
                return false;
            }
            case 6: {
                int size = super.getPreferredHeight() - visibleRectangle[3];
                if (!cfocused) break;
                int tmp = visibleRectangle[1];
                if (tmp < size) {
                    visibleRectangle[1] = Math.min(tmp + viewportHeight / 4, size);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    boolean isMatchForButton() {
        return this.appearance == 2 && super.isMatchForButton();
    }

    boolean isMatchForHyperlink() {
        return this.appearance == 1 && super.isMatchForHyperlink();
    }

    int getPreferredContentWidth(int contentHeight, int containerClientWidth) {
        Image image = this.image;
        return image != null ? image.getWidth() + 8 : 0;
    }

    int getPreferredContentHeight(int contentWidth) {
        Image image = this.image;
        return image != null ? image.getHeight() + 8 : 0;
    }
}

