/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.TextOutput;
import javax.microedition.lcdui.TextOutputMultilined;
import javax.microedition.lcdui.TextOutputMultilinedExt;
import malik.emulator.media.graphics.RasterCanvas;

public class StringItem
extends Item {
    private boolean controlFocused;
    private boolean pointerFocused;
    private boolean pointerPressed;
    private int contentWidth;
    private int contentHeight;
    private int appearance;
    private String text;
    private Font font;
    private TextOutputMultilined lines;

    public StringItem(String label, String text) {
        this(0, -1, -1, label, null, null, null, text, null, 0);
    }

    public StringItem(String label, String text, int appearance) {
        this(0, -1, -1, label, null, null, null, text, null, appearance);
    }

    public StringItem(int layout, int lockedWidth, int lockedHeight, String label, Command[] commands, Command defaultCommand, ItemCommandListener listener, String text, Font font, int appearance) {
        super(layout, lockedWidth, lockedHeight, label, commands, defaultCommand, listener);
        Font font2;
        if (appearance != 0 && appearance != 1 && appearance != 2) {
            throw new IllegalArgumentException("StringItem: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 appearance.");
        }
        this.appearance = appearance;
        this.text = text;
        if (font != null) {
            font2 = font;
        } else if (appearance != 1) {
            font2 = Font.getFont(0);
        } else {
            Font f = Font.getFont(0);
            font2 = Font.getFont(f.getFace(), f.getStyle() | 4, f.getSize());
        }
        this.font = font2;
        TextOutputMultilinedExt lines = new TextOutputMultilinedExt(0);
        this.lines = lines;
        ((TextOutput)lines).setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        TextOutputMultilined lines;
        this.text = text;
        TextOutputMultilined textOutputMultilined = lines = this.lines;
        synchronized (lines) {
            lines.setText(text);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.notifyUpdate();
            return;
        }
    }

    public void setFont(Font font) {
        this.font = font == null ? Font.getFont(0) : font;
        this.notifyUpdate();
    }

    public int getAppearanceMode() {
        return this.appearance;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintContent(Graphics render, int contentWidth, int contentHeight) {
        TextOutputMultilined lines;
        boolean pressed = this.pointerPressed;
        Font font = this.font;
        render.setFont(font);
        TextOutputMultilined textOutputMultilined = lines = this.lines;
        synchronized (lines) {
            int t;
            int l;
            int a;
            lines.split(font, contentWidth - 8);
            int s = font.getHeight();
            int ct = render.getClipY();
            int cb = ct + render.getClipHeight();
            int len = lines.getLinesCount();
            char[] chars = lines.getChars();
            if (this.isMatchForButton()) {
                a = pressed ? 1 : (this.controlFocused ? 3 : 0);
                render.drawElementOfGUI(4, a, 0, 0, 0, contentWidth, contentHeight);
                render.setColor(RasterCanvas.getSystemColor((int)(a + 36)));
                l = contentWidth / 2 + (pressed ? 1 : 0);
                t = (contentHeight - len * s) / 2 + (pressed ? 1 : 0);
                a = 17;
            } else if (this.isMatchForHyperlink()) {
                a = pressed ? 1 : (this.controlFocused ? 3 : 0);
                render.setColor(RasterCanvas.getSystemColor((int)(a + 36)));
                l = pressed ? 5 : 4;
                t = pressed ? 5 : 4;
                a = 20;
            } else {
                render.setColor(RasterCanvas.getSystemColor((int)40));
                l = 4;
                t = 4;
                a = 20;
            }
            int i = 0;
            while (i < len) {
                if (t < cb && t + s > ct) {
                    render.drawChars(chars, lines.getLineStart(i), lines.getLineLength(i), l, t, a);
                }
                t += s;
                ++i;
            }
            // ** MonitorExit[var16_7] (shouldn't be in output)
            return;
        }
    }

    void onSizeChanged(int contentWidth, int contentHeight) {
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
    }

    void onContentPointerPressed(int x, int y, int button) {
        if (button != 0 || !this.isMatchForButton() && !this.isMatchForHyperlink()) {
            return;
        }
        this.pointerFocused = true;
        this.pointerPressed = true;
        this.notifyPaint();
    }

    void onContentPointerDragged(int x, int y) {
        if (!this.pointerFocused || this.pointerPressed == (this.pointerPressed = x >= 0 && x < this.contentWidth && y >= 0 && y < this.contentHeight)) {
            return;
        }
        this.notifyPaint();
    }

    void onContentPointerReleased(int x, int y, int button) {
        if (button != 0) {
            return;
        }
        boolean pressed = this.pointerPressed;
        this.pointerFocused = false;
        this.pointerPressed = false;
        if (!pressed) {
            return;
        }
        this.notifyPaint();
        this.notifyCommandAction(this.getCommands().getDefaultCommand());
    }

    void onTraverseOut() {
        this.controlFocused = false;
        if (this.isMatchForButton()) {
            this.notifyPaint();
        }
    }

    boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        boolean cfocused = this.controlFocused;
        this.controlFocused = true;
        if (!cfocused && this.isMatchForButton()) {
            this.notifyPaint();
        }
        if (this.pointerFocused) {
            return true;
        }
        switch (direction) {
            case 1: {
                if (!cfocused) break;
                int tmp = visibleRectangle[1];
                if (tmp > 0) {
                    visibleRectangle[1] = Math.max(tmp - viewportHeight / 4, 0);
                    return true;
                }
                return false;
            }
            case 2: {
                if (!cfocused) break;
                int tmp = visibleRectangle[0];
                if (tmp > 0) {
                    visibleRectangle[0] = Math.max(tmp - viewportWidth / 4, 0);
                    return true;
                }
                return false;
            }
            case 5: {
                int size = super.getPreferredWidth() - visibleRectangle[2];
                if (!cfocused) break;
                int tmp = visibleRectangle[0];
                if (tmp < size) {
                    visibleRectangle[0] = Math.min(tmp + viewportWidth / 4, size);
                    return true;
                }
                return false;
            }
            case 6: {
                int size = super.getPreferredHeight() - visibleRectangle[3];
                if (!cfocused) break;
                int tmp = visibleRectangle[1];
                if (tmp < size) {
                    visibleRectangle[1] = Math.min(tmp + viewportHeight / 4, size);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    boolean isMatchForButton() {
        return this.appearance == 2 && super.isMatchForButton();
    }

    boolean isMatchForHyperlink() {
        return this.appearance == 1 && super.isMatchForHyperlink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPreferredContentWidth(int contentHeight, int containerClientWidth) {
        TextOutputMultilined lines;
        int result = 0;
        Font font = this.font;
        TextOutputMultilined textOutputMultilined = lines = this.lines;
        synchronized (lines) {
            char[] chars = lines.getChars();
            lines.split(font, 0x7FFFFFF7);
            int i = lines.getLinesCount();
            while (i-- > 0) {
                int tmp = font.charsWidth(chars, lines.getLineStart(i), lines.getLineLength(i));
                if (result >= tmp) continue;
                result = tmp;
            }
            // ** MonitorExit[var9_6] (shouldn't be in output)
            if ((result += 8) > containerClientWidth) {
                result = containerClientWidth;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPreferredContentHeight(int contentWidth) {
        TextOutputMultilined lines;
        Font font = this.font;
        if (contentWidth < 0) {
            contentWidth = Integer.MAX_VALUE;
        }
        TextOutputMultilined textOutputMultilined = lines = this.lines;
        synchronized (lines) {
            lines.split(font, contentWidth - 8);
            int result = lines.getLinesCount() * font.getHeight() + 8;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return result;
        }
    }
}

