/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class LayerManager {
    private int viewLeft;
    private int viewTop;
    private int viewWidth = Integer.MAX_VALUE;
    private int viewHeight = Integer.MAX_VALUE;
    private int count;
    private Layer[] layers = new Layer[2];
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics render, int left, int top) {
        if (render == null) {
            throw new NullPointerException("LayerManager.paint: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 render \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int clipLeft = render.getClipX();
        int clipTop = render.getClipY();
        int clipWidth = render.getClipWidth();
        int clipHeight = render.getClipHeight();
        Object object = this.lock;
        synchronized (object) {
            int viewLeft = this.viewLeft;
            int viewWidth = this.viewWidth;
            int viewRight = viewLeft + viewWidth;
            int viewTop = this.viewTop;
            int viewHeight = this.viewHeight;
            int viewBottom = viewTop + viewHeight;
            render.translate(left - viewLeft, top - viewTop);
            render.clipRect(viewLeft, viewTop, viewWidth, viewHeight);
            try {
                Layer[] layers = this.layers;
                int i = this.count;
                while (i-- > 0) {
                    int layerTop;
                    int layerLeft;
                    Layer layer = layers[i];
                    if (!layer.isVisible() || (layerLeft = layer.getX()) >= viewRight || (layerTop = layer.getY()) >= viewBottom || layerLeft + layer.getWidth() <= viewLeft || layerTop + layer.getHeight() <= viewTop) continue;
                    layer.paint(render);
                }
            }
            finally {
                render.translate(viewLeft - left, viewTop - top);
                render.setClip(clipLeft, clipTop, clipWidth, clipHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewWindow(int left, int top, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("LayerManager.setViewWindow: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.viewLeft = left;
            this.viewTop = top;
            this.viewWidth = width;
            this.viewHeight = height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Layer layer, int layerIndex) {
        if (layer == null) {
            throw new NullPointerException("LayerManager.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 layer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int count = this.count;
            int olderIndex = this.indexOf(layer);
            if (layerIndex < 0 || layerIndex > (olderIndex >= 0 ? count - 1 : count)) {
                error = true;
            } else {
                int c;
                Object[] layers = this.layers;
                if (olderIndex >= 0) {
                    c = count - olderIndex - 1;
                    if (c > 0) {
                        Array.copy((Object[])layers, (int)(olderIndex + 1), (Object[])layers, (int)olderIndex, (int)c);
                    }
                    --count;
                } else if (count == layers.length) {
                    Object[] objectArray = layers;
                    this.layers = new Layer[count << 1];
                    layers = this.layers;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.layers, (int)0, (int)count);
                }
                c = count - layerIndex;
                if (c > 0) {
                    Array.copy((Object[])layers, (int)layerIndex, (Object[])layers, (int)(layerIndex + 1), (int)c);
                }
                layers[layerIndex] = layer;
                this.count = ++count;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("LayerManager.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 layerIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Layer layer) {
        if (layer == null) {
            throw new NullPointerException("LayerManager.remove: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 layer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            int layerIndex = this.indexOf(layer);
            if (layerIndex >= 0) {
                int count = this.count;
                Object[] layers = this.layers;
                int c = count - layerIndex - 1;
                if (c > 0) {
                    Array.copy((Object[])layers, (int)(layerIndex + 1), (Object[])layers, (int)layerIndex, (int)c);
                }
                layers[--count] = null;
                this.count = count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Layer layer) {
        if (layer == null) {
            throw new NullPointerException("LayerManager.append: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 layer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            int count = this.count;
            Object[] layers = this.layers;
            int olderIndex = this.indexOf(layer);
            if (olderIndex >= 0) {
                int c = count - olderIndex - 1;
                if (c > 0) {
                    Array.copy((Object[])layers, (int)(olderIndex + 1), (Object[])layers, (int)olderIndex, (int)c);
                }
            } else if (count == layers.length) {
                Object[] objectArray = layers;
                this.layers = new Layer[count << 1];
                layers = this.layers;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.layers, (int)0, (int)count);
            }
            int n = --count;
            layers[n] = layer;
            this.count = ++count;
        }
    }

    public int getSize() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer getLayerAt(int layerIndex) {
        Layer result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (layerIndex < 0 || layerIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.layers[layerIndex];
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("LayerManager.getLayerAt: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 layerIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    private int indexOf(Layer layer) {
        Layer[] layers = this.layers;
        int i = this.count;
        while (i-- > 0) {
            if (layers[i] != layer) continue;
            return i;
        }
        return -1;
    }
}

