/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.j2me.input;

import malik.emulator.io.j2me.input.InputMode;
import malik.emulator.io.j2me.input.SystemInputMode;

public final class AvailableInputModes {
    private static int COUNT;
    private static InputMode[] MODES;
    private static final Object LOCK;

    static {
        InputMode systemInputMode;
        try {
            systemInputMode = (InputMode)Class.forName(System.getSystemProperty((String)"malik.emulator.microedition.input.mode.class")).newInstance();
        }
        catch (Exception exception) {
            systemInputMode = new SystemInputMode();
        }
        LOCK = new Object();
        AvailableInputModes.register(systemInputMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(InputMode mode) {
        if (mode == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (MODES == null) {
                MODES = new InputMode[16];
            }
            if (COUNT == MODES.length) {
                Object[] objectArray = MODES;
                MODES = new InputMode[COUNT << 1];
                Array.copy((Object[])objectArray, (int)0, (Object[])MODES, (int)0, (int)COUNT);
            }
            AvailableInputModes.MODES[AvailableInputModes.COUNT++] = mode;
        }
    }

    public static int getCount() {
        return COUNT;
    }

    public static InputMode getSystemInputMode() {
        return MODES[0];
    }

    public static InputMode getInputModeAt(int index) {
        return index >= 0 && index < COUNT ? MODES[index] : null;
    }

    public static InputMode getInputMode(String characterSubset) {
        int i = COUNT;
        while (i-- > 0) {
            InputMode mode = MODES[i];
            if (!mode.isCharacterSubset(characterSubset)) continue;
            return mode;
        }
        return MODES[0];
    }

    private AvailableInputModes() {
    }
}

