/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system;

import com.nokia.mid.ui.DirectUtils;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import malik.emulator.fileformats.graphics.png.PNGEncoder;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.system.Console;
import malik.emulator.microedition.system.SearchConsoleCommand;
import malik.emulator.microedition.system.SystemManager;
import malik.emulator.util.StringBuilder;

final class ImagesSearchConsoleCommand
extends SearchConsoleCommand
implements CommandListener,
ItemCommandListener {
    private static final int GLYPH_COLOR = RasterCanvas.getSystemColor((int)36);
    private boolean delay;
    private int current;
    private Image[] images;
    private Image imagePrev;
    private Image imageNext;
    private Command commandSaveAction;
    private Command commandCancel;
    private Command commandSelect;
    private Command commandSave;
    private Command commandBack;
    private Gauge itemProgressBar;
    private StringItem itemImageNum;
    private ImageItem itemImagePrev;
    private ImageItem itemImageNext;
    private ImageItem itemImageShow;
    private TextField itemFileName;
    private Alert screenProgress;
    private Form screenImages;
    private Form screenEmpty;
    private Form screenSave;

    public ImagesSearchConsoleCommand(SystemManager manager) {
        super("\u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f", manager);
    }

    public void commandAction(Command command, Displayable screen) {
        if (screen == this.screenImages) {
            if (command == this.commandSave) {
                this.getItemFileName().setString("/\u0438\u043c\u044f.png");
                DeviceManager.getInstance().getMainDisplay().setCurrent((Displayable)this.getScreenSave());
                return;
            }
            if (command == this.commandBack) {
                this.images = null;
                this.returnToSystem();
            }
            return;
        }
        if (screen == this.screenSave) {
            if (command == this.commandSaveAction) {
                int index;
                Image[] found = this.images;
                if (this.images != null && (index = this.current) >= 0 && index < found.length) {
                    final String fileName = this.getItemFileName().getString();
                    final Image image = found[index];
                    new Thread("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f"){

                        public void run() {
                            Image destImage = image;
                            String destFileName = fileName;
                            System.out.println(new StringBuilder().append("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0432 ").append(destFileName).append(" \u2026").toString());
                            try {
                                int width = destImage.getWidth();
                                int height = destImage.getHeight();
                                int[] pixels = new int[width * height];
                                destImage.getRGB(pixels, 0, width, 0, 0, width, height);
                                PNGEncoder encoder = new PNGEncoder();
                                encoder.setPixels(true, width, height, pixels);
                                FileConnection connection = (FileConnection)Connector.open((String)"file://".concat(destFileName));
                                try {
                                    if (connection.exists()) {
                                        connection.delete();
                                    }
                                    connection.create();
                                    OutputStream stream = connection.openOutputStream();
                                    try {
                                        encoder.saveToOutputStream(stream);
                                    }
                                    finally {
                                        stream.close();
                                    }
                                }
                                finally {
                                    connection.close();
                                }
                                System.out.println(new StringBuilder().append("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e \u0432 ").append(destFileName).append('.').toString());
                            }
                            catch (Exception e) {
                                System.out.println(new StringBuilder().append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0432 ").append(destFileName).append('.').toString());
                                e.printRealStackTrace();
                            }
                        }
                    }.start();
                }
            }
            DeviceManager.getInstance().getMainDisplay().setCurrent((Displayable)this.getScreenImages());
            return;
        }
        if (screen == this.screenProgress && command == this.commandCancel) {
            this.cancelSearchProcess();
            return;
        }
        if (screen == this.screenEmpty && command == this.commandBack) {
            this.returnToSystem();
        }
    }

    public void commandAction(Command command, Item item) {
        int len;
        Image[] found = this.images;
        if (this.images == null || (len = found.length) <= 0) {
            return;
        }
        if (item == this.itemImagePrev) {
            this.current = this.current == 0 ? len - 1 : this.current - 1;
            this.updateScreenImages();
            return;
        }
        if (item == this.itemImageNext) {
            this.current = this.current == len - 1 ? 0 : this.current + 1;
            this.updateScreenImages();
        }
    }

    protected void searchProcess() {
        Object[] memory = Memory.getAllObjects();
        Gauge progress = this.getItemProgressBar();
        Vector<Object> images = new Vector<Object>();
        int len = memory != null ? memory.length : 0;
        if (len >= 100) {
            progress.setMaxValue(len / 100);
        }
        int i = 0;
        while (i < len) {
            Object curr;
            if (i % 100 == 0) {
                progress.setValue(i / 100);
                if (this.delay) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printRealStackTrace();
                    }
                }
            }
            if ((curr = memory[i]) instanceof Image) {
                images.addElement(curr);
            }
            ++i;
        }
        int count = images.size();
        if (count > 0) {
            this.images = new Image[count];
            images.copyInto(this.images);
        }
        progress.setValue(len / 100);
        if (this.delay) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printRealStackTrace();
            }
        }
    }

    protected void showProgressScreen(Display display) {
        Form screen = this.getScreenEmpty();
        screen.setTitle("\u041b\u044e\u0431\u0438\u0442\u0435 \u043a\u0440\u0430\u0441\u0438\u0442\u044c \u043f\u0430\u0441\u0445\u0430\u043b\u044c\u043d\u044b\u0435 \u044f\u0439\u0446\u0430?");
        display.setCurrent(this.getScreenProgress(), (Displayable)screen);
    }

    protected void showFoundScreen(Display display) {
        Form screen;
        this.current = 0;
        Image[] found = this.images;
        if (this.images == null || found.length <= 0) {
            screen = this.getScreenEmpty();
        } else {
            this.updateScreenImages();
            screen = this.getScreenImages();
        }
        screen.setTitle("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f");
        display.setCurrent((Displayable)screen);
    }

    protected void execute(String[] arguments, Console console) {
        this.delay = true;
        super.execute(arguments, console);
    }

    protected void executeInBackground() {
        this.delay = false;
        super.executeInBackground();
    }

    private void updateScreenImages() {
        int len;
        int index;
        Image[] found = this.images;
        if (this.images != null && (index = this.current) >= 0 && index < (len = found.length)) {
            this.getItemImageShow().setImage(found[index]);
            this.getItemImageNum().setText(new StringBuilder().append(' ').append(index + 1).append(" / ").append(len).toString());
        }
    }

    private Image getImagePrev() {
        Image result = this.imagePrev;
        if (result == null) {
            result = this.imagePrev = DirectUtils.createImage((int)24, (int)24, (int)0);
            Graphics render = this.imagePrev.getGraphics();
            render.setColor(GLYPH_COLOR);
            render.fillTriangle(19, 1, 9, 11, 19, 21);
            render.fillRect(4, 1, 5, 21);
        }
        return result;
    }

    private Image getImageNext() {
        Image result = this.imageNext;
        if (result == null) {
            result = this.imageNext = DirectUtils.createImage((int)24, (int)24, (int)0);
            Graphics render = this.imageNext.getGraphics();
            render.setColor(GLYPH_COLOR);
            render.fillTriangle(4, 1, 14, 11, 4, 21);
            render.fillRect(15, 1, 5, 21);
        }
        return result;
    }

    private Command getCommandSaveAction() {
        Command result = this.commandSaveAction;
        if (result == null) {
            result = this.commandSaveAction = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 4, 0);
        }
        return result;
    }

    private Command getCommandCancel() {
        Command result = this.commandCancel;
        if (result == null) {
            result = this.commandCancel = new Command("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c", 3, 0);
        }
        return result;
    }

    private Command getCommandSelect() {
        Command result = this.commandSelect;
        if (result == null) {
            result = this.commandSelect = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, 0);
        }
        return result;
    }

    private Command getCommandSave() {
        Command result = this.commandSave;
        if (result == null) {
            result = this.commandSave = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c\u2026", 1, 0);
        }
        return result;
    }

    private Command getCommandBack() {
        Command result = this.commandBack;
        if (result == null) {
            result = this.commandBack = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        }
        return result;
    }

    private Gauge getItemProgressBar() {
        Gauge result = this.itemProgressBar;
        if (result == null) {
            result = this.itemProgressBar = new Gauge(null, false, 1, 0);
        }
        return result;
    }

    private StringItem getItemImageNum() {
        StringItem result = this.itemImageNum;
        if (result == null) {
            result = this.itemImageNum = new StringItem(null, " ");
            this.itemImageNum.setLayout(2096);
        }
        return result;
    }

    private ImageItem getItemImagePrev() {
        ImageItem result = this.itemImagePrev;
        if (result == null) {
            result = this.itemImagePrev = new ImageItem(null, this.getImagePrev(), 48, null, 2);
            this.itemImagePrev.setItemCommandListener((ItemCommandListener)this);
            result.setDefaultCommand(this.getCommandSelect());
        }
        return result;
    }

    private ImageItem getItemImageNext() {
        ImageItem result = this.itemImageNext;
        if (result == null) {
            result = this.itemImageNext = new ImageItem(null, this.getImageNext(), 48, null, 2);
            this.itemImageNext.setItemCommandListener((ItemCommandListener)this);
            result.setDefaultCommand(this.getCommandSelect());
        }
        return result;
    }

    private ImageItem getItemImageShow() {
        ImageItem result = this.itemImageShow;
        if (result == null) {
            result = this.itemImageShow = new ImageItem(null, null, 256, null);
        }
        return result;
    }

    private TextField getItemFileName() {
        TextField result = this.itemFileName;
        if (result == null) {
            result = this.itemFileName = new TextField("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430", null, 128, 0);
            this.itemFileName.setLayout(2048);
        }
        return result;
    }

    private Alert getScreenProgress() {
        Alert result = this.screenProgress;
        if (result == null) {
            result = this.screenProgress = new Alert(null, "\u041f\u043e\u0438\u0441\u043a \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439 \u0432 \u043f\u0430\u043c\u044f\u0442\u0438\u2026", null, AlertType.INFO);
            this.screenProgress.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandCancel());
            result.setIndicator(this.getItemProgressBar());
        }
        return result;
    }

    private Form getScreenImages() {
        Form result = this.screenImages;
        if (result == null) {
            result = this.screenImages = new Form(null, new Item[]{this.getItemImagePrev(), this.getItemImageNext(), this.getItemImageNum(), this.getItemImageShow()});
            this.screenImages.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandBack());
            result.addCommand(this.getCommandSave());
        }
        return result;
    }

    private Form getScreenEmpty() {
        Form result = this.screenEmpty;
        if (result == null) {
            String text = "(\u043d\u0435\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439)";
            StringItem empty = new StringItem(null, "(\u043d\u0435\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439)");
            empty.setLayout(3);
            Font font = Font.getFont((int)0, (int)1, (int)8);
            empty.setFont(font);
            empty.setPreferredSize(font.stringWidth(text), -1);
            result = this.screenEmpty = new Form(null, new Item[]{empty});
            this.screenEmpty.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandBack());
            result.getHorizontalScrollBar().hide();
        }
        return result;
    }

    private Form getScreenSave() {
        Form result = this.screenSave;
        if (result == null) {
            result = this.screenSave = new Form("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", new Item[]{this.getItemFileName()});
            this.screenSave.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandSaveAction());
            result.addCommand(this.getCommandBack());
            result.getHorizontalScrollBar().hide();
        }
        return result;
    }
}

