/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.protocol.sms;

import java.io.IOException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import malik.emulator.microedition.io.ConnectionClosedException;
import malik.emulator.microedition.io.CustomConnection;
import malik.emulator.microedition.system.protocol.InboundConnections;
import malik.emulator.microedition.system.protocol.sms.BinaryShortMessage;
import malik.emulator.microedition.system.protocol.sms.ShortMessage;
import malik.emulator.microedition.system.protocol.sms.TextShortMessage;

public class ClientMessageConnection
extends CustomConnection
implements MessageConnection {
    public static final int MAXIMUM_LENGTH = 1024;
    public static final int LOCAL_PORT = 1200;
    public static final String LOCAL_ADDRESS = "sms://:1200";

    private static int getPort(String address) {
        int result;
        if (address == null || !address.toLowerCase().startsWith("sms://:")) {
            return 1200;
        }
        try {
            result = Integer.parseInt(address.substring("sms://:".length()));
        }
        catch (NumberFormatException numberFormatException) {
            return 1200;
        }
        return result < 0 || result > 65535 ? 1200 : result;
    }

    public ClientMessageConnection(String remoteAddress) {
        super(remoteAddress);
    }

    public void setMessageListener(MessageListener listener) throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("MessageConnection.setMessageListener: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        throw new IOException("MessageConnection.setMessageListener: \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f.");
    }

    public void send(Message message) throws IOException {
        ShortMessage ourmsg;
        block7: {
            block6: {
                if (this.isConnectionClosed()) {
                    throw new ConnectionClosedException("MessageConnection.send: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
                }
                if (message == null) {
                    throw new NullPointerException("MessageConnection.send: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 message \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                if (!(message instanceof ShortMessage)) break block6;
                ourmsg = (ShortMessage)message;
                if (ourmsg.creator == this) break block7;
            }
            throw new IllegalArgumentException("MessageConnection.send: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 message \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d \u043c\u0435\u0442\u043e\u0434\u043e\u043c newMessage.");
        }
        int len = ourmsg.getLength();
        if (len < 0 || len > 1024) {
            throw new IllegalArgumentException("MessageConnection.send: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 message \u0438\u043c\u0435\u0435\u0442 \u0431\u043e\u043b\u044c\u0448\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        InboundConnections.instance.notifyReceiveData(1, ClientMessageConnection.getPort(ourmsg.recipientAddress), ourmsg.createInboundCopy());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int numberOfSegments(Message message) {
        if (!(message instanceof ShortMessage)) return 0;
        ShortMessage ourmsg = (ShortMessage)message;
        if (ourmsg.creator != this) return 0;
        int len = ourmsg.getLength();
        if (len < 0) return 0;
        if (len <= 1024) return 1;
        return 0;
    }

    public Message receive() throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("MessageConnection.receive: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        throw new IOException("MessageConnection.receive: \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f.");
    }

    public Message newMessage(String type) {
        if ("binary".equals(type)) {
            return new BinaryShortMessage(this, false, LOCAL_ADDRESS, super.getURL(), Long.MIN_VALUE, null);
        }
        if ("text".equals(type)) {
            return new TextShortMessage(this, false, LOCAL_ADDRESS, super.getURL(), Long.MIN_VALUE, null);
        }
        throw new IllegalArgumentException("MessageConnection.newMessage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public Message newMessage(String type, String address) {
        if ("binary".equals(type)) {
            return new BinaryShortMessage(this, false, LOCAL_ADDRESS, address, Long.MIN_VALUE, null);
        }
        if ("text".equals(type)) {
            return new TextShortMessage(this, false, LOCAL_ADDRESS, address, Long.MIN_VALUE, null);
        }
        throw new IllegalArgumentException("MessageConnection.newMessage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public final void setURL(String url) {
        throw new IllegalStateException("CustomConnection.setURL: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0430\u0434\u0440\u0435\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f.");
    }
}

