/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.jpeg;

import java.io.IOException;
import malik.emulator.fileformats.graphics.jpeg.JPEGBitInputStream;

final class ChaffmanTable {
    private final byte[] valueSet;
    private final short[] valueIndices;
    private final int[] minCodes;
    private final int[] maxCodes;

    public ChaffmanTable(byte[] valueSet, short[] valueIndices, int[] minCodes, int[] maxCodes) {
        this.valueSet = valueSet;
        this.valueIndices = valueIndices;
        this.minCodes = minCodes;
        this.maxCodes = maxCodes;
    }

    public int readValue(JPEGBitInputStream stream) throws IOException {
        int code = stream.readBit();
        int[] maxCodes = this.maxCodes;
        int i = 0;
        while (code > maxCodes[i]) {
            code = code << 1 | stream.readBit();
            ++i;
        }
        return this.valueSet[this.valueIndices[i] + code - this.minCodes[i]] & 0xFF;
    }
}

