/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.Connection;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.system.user.UserSystemManager;

public class LocalDevice {
    private static final LocalDevice instance = DeviceManager.getInstance() instanceof UserSystemManager ? new LocalDevice() : null;
    private int discoverableMode = 10390272;
    private final DiscoveryAgent agent = new DiscoveryAgent();

    public static boolean isPowerOn() {
        return DeviceManager.getInstance() instanceof UserSystemManager;
    }

    public static LocalDevice getLocalDevice() throws BluetoothStateException {
        LocalDevice result = instance;
        if (result == null) {
            throw new BluetoothStateException("LocalDevice.getLocalDevice: Bluetooth API \u043d\u0435 \u0431\u044b\u043b \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d \u043d\u0430 \u044d\u0442\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0435.");
        }
        return result;
    }

    public static String getProperty(String key) {
        if ("bluetooth.api.version".equals(key)) {
            return "1.1.1";
        }
        if ("bluetooth.master.switch".equals(key)) {
            return "false";
        }
        if ("bluetooth.sd.attr.retrievable.max".equals(key)) {
            return "1";
        }
        if ("bluetooth.connected.devices.max".equals(key)) {
            return "7";
        }
        if ("bluetooth.l2cap.receiveMTU.max".equals(key)) {
            return "512";
        }
        if ("bluetooth.sd.trans.max".equals(key)) {
            return "1";
        }
        if ("bluetooth.connected.inquiry.scan".equals(key)) {
            return "false";
        }
        if ("bluetooth.connected.page.scan".equals(key)) {
            return "false";
        }
        if ("bluetooth.connected.inquiry".equals(key)) {
            return "false";
        }
        if ("bluetooth.connected.page".equals(key)) {
            return "false";
        }
        return null;
    }

    private LocalDevice() {
    }

    public void updateRecord(ServiceRecord record) throws ServiceRegistrationException {
        if (record == null) {
            throw new NullPointerException("LocalDevice.updateRecord: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 record \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        throw new IllegalArgumentException("LocalDevice.updateRecord: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0443\u0441\u043b\u0443\u0433\u0438.");
    }

    public boolean setDiscoverable(int mode) throws BluetoothStateException {
        if (mode != 0 && (mode < 10390272 || mode > 10390335)) {
            throw new IllegalArgumentException("LocalDevice.setDiscoverable: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 mode \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        DiscoveryAgent agent = this.agent;
        if (agent.inquiryOperation != null || agent.searchOperation != null) {
            throw new BluetoothStateException("LocalDevice.setDiscoverable: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0438\u044f.");
        }
        if (mode == 0 || mode == 10390323 || mode == 10390272) {
            this.discoverableMode = mode;
            return true;
        }
        return false;
    }

    public int getDiscoverable() {
        return this.discoverableMode;
    }

    public String getFriendlyName() {
        return null;
    }

    public String getBluetoothAddress() {
        return "050710DF0BAC";
    }

    public DeviceClass getDeviceClass() {
        return null;
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.agent;
    }

    public ServiceRecord getRecord(Connection notifier) {
        if (notifier == null) {
            throw new NullPointerException("LocalDevice.getRecord: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 notifier \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        throw new IllegalArgumentException("LocalDevice.getRecord: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435.");
    }
}

