/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ItemCommandListener;

public class ButtonSet
extends CustomItem {
    private int width;
    private int height;
    private int pressed;
    private int count;
    private int[][] buttons;
    private Image background;
    private Object lock;

    public ButtonSet(int layout, String label, Image buttonsImage) {
        this(layout, label, null, null, null, buttonsImage);
    }

    public ButtonSet(int layout, String label, Command[] commands, Command defaultCommand, ItemCommandListener listener, Image buttonsImage) {
        super(layout, -1, -1, label, commands, defaultCommand, listener);
        if (buttonsImage == null) {
            throw new NullPointerException("ButtonSet: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 buttonsImage \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.width = buttonsImage.getWidth() / 2;
        this.height = buttonsImage.getHeight();
        this.pressed = -1;
        this.buttons = new int[1][];
        this.background = buttonsImage;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addButton(int buttonID, int left, int top, int width, int height) {
        int buttonLeft = Math.max(0, left);
        int buttonTop = Math.max(0, top);
        int buttonRight = Math.min(this.width, left + width);
        int buttonBottom = Math.min(this.height, top + height);
        if (buttonLeft >= buttonRight || buttonTop >= buttonBottom) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int len = this.count;
            Object btns = this.buttons;
            if (len == this.buttons.length) {
                int[][] nArray = btns;
                int[][] nArrayArray = new int[(len << 1) + 1][];
                this.buttons = nArrayArray;
                btns = nArrayArray;
                Array.copy((Object[])nArray, (int)0, (Object[])nArrayArray, (int)0, (int)len);
            }
            btns[len++] = new int[]{buttonID, buttonLeft, buttonTop, buttonRight, buttonBottom};
            this.count = len;
        }
    }

    public int getPressedButtonID() {
        int p = this.pressed;
        return p >= 0 ? this.buttons[p][0] : 0;
    }

    protected void paint(Graphics render, int contentWidth, int contentHeight) {
        int width = this.width;
        int pressed = this.pressed;
        Image background = this.background;
        render.drawRegion(background, 0, 0, width, this.height, 0, 0, 0, 20);
        if (pressed >= 0) {
            int[] button = this.buttons[pressed];
            int left = button[1];
            int top = button[2];
            render.drawRegion(background, width + left, top, button[3] - left, button[4] - top, 0, left, top, 20);
        }
    }

    protected void pointerPressed(int x, int y) {
        int p = this.getPressedIndex(x, y);
        if (p != this.pressed && p >= 0) {
            this.pressed = p;
            super.notifyStateChanged();
            this.repaint();
        }
    }

    protected int getMinContentWidth() {
        return this.width;
    }

    protected int getMinContentHeight() {
        return this.height;
    }

    protected int getPrefContentWidth(int contentHeight) {
        return this.width;
    }

    protected int getPrefContentHeight(int contentWidth) {
        return this.height;
    }

    private int getPressedIndex(int x, int y) {
        int[][] btns = this.buttons;
        int i = this.count;
        while (i-- > 0) {
            int[] button = btns[i];
            if (x < button[1] || y < button[2] || x >= button[3] || y >= button[4]) continue;
            return i;
        }
        return -1;
    }
}

