/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp.protocol;

import java.io.IOException;
import java.util.QueueOfObjects;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import malik.emulator.io.j2me.InboundConnection;
import malik.emulator.io.j2me.VirtualConnectionFactory;
import malik.emulator.midp.protocol.URLParser;
import malik.emulator.midp.protocol.WirelessMessageDefaultPortListener;
import malik.emulator.midp.protocol.file.ReadOnlyFileConnection;
import malik.emulator.midp.protocol.resource.ReadOnlyResourceConnection;
import malik.emulator.midp.protocol.sms.ClientMessageConnection;
import malik.emulator.midp.protocol.sms.ServerMessageConnection;

public class SupportedConnections
implements Runnable,
VirtualConnectionFactory {
    public static final int DEFAULT_PORT_FOR_RECEIVE_WIRELESS_MESSAGES = 1200;
    private InboundConnection[] inboundConnections = new InboundConnection[2];
    private QueueOfObjects events = new QueueOfObjects(16);
    private URLParser urlParser = new URLParser();

    public SupportedConnections() {
        new Thread((Runnable)this, "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u043e\u0442 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439").start();
        this.openDefaultConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection connection) throws IOException {
        if (connection instanceof InboundConnection) {
            QueueOfObjects queueOfObjects = this.events;
            synchronized (queueOfObjects) {
                int i = this.indexOfInboundConnection(connection);
                if (i >= 0) {
                    this.inboundConnections[i] = null;
                }
            }
        }
    }

    public void registerConnection(String url, String midlet, String filter) throws IOException, ClassNotFoundException {
    }

    public boolean unregisterConnection(String url) {
        return false;
    }

    public boolean platformRequest(String url) throws ConnectionNotFoundException {
        return false;
    }

    public int checkPermission(String permission) {
        return 1;
    }

    public String[] listConnections(boolean available) {
        return null;
    }

    public String getFilter(String url) {
        return null;
    }

    public String getMIDlet(String url) {
        return null;
    }

    public Connection openConnection(String url, int mode, boolean timeouts) throws IOException {
        URLParser parser = this.urlParser;
        parser.parse(url);
        String protocol = parser.getProtocol();
        String userInfo = parser.getUserInfo();
        String remoteHost = parser.getHostName();
        int remotePort = parser.getPort();
        String remotePath = parser.getPath();
        String remoteQuery = parser.getQuery();
        Connection result = this.openConnection(url, protocol, userInfo, remoteHost, remotePort, remotePath, remoteQuery, mode, timeouts);
        if (result instanceof InboundConnection) {
            this.checkAndRegisterInboundConnection(protocol, remotePort, (InboundConnection)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        QueueOfObjects events = this.events;
        while (true) {
            Runnable event;
            this.waitEvent();
            if (events.isEmpty()) continue;
            QueueOfObjects queueOfObjects = events;
            synchronized (queueOfObjects) {
                event = (Runnable)events.peek();
                events.removeTailElement();
            }
            try {
                event.run();
                continue;
            }
            catch (Throwable e) {
                e.printRealStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEvent(Runnable event) {
        QueueOfObjects events;
        QueueOfObjects queueOfObjects = events = this.events;
        synchronized (events) {
            events.push((Object)event);
            events.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final InboundConnection getInboundConnection(String protocol, int localPort) {
        if (protocol == null) {
            return null;
        }
        InboundConnection result = null;
        InboundConnection[] c = this.inboundConnections;
        int i = this.inboundConnections.length;
        while (i-- > 0) {
            try {
                String connectionProtocol;
                InboundConnection connection = c[i];
                if (connection == null || (connectionProtocol = connection.getProtocol()) == null || !protocol.equalsIgnoreCase(connectionProtocol) || localPort != connection.getLocalPort()) continue;
                result = connection;
                break;
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    protected void openDefaultConnections() {
        try {
            MessageConnection defaultMessagePort = (MessageConnection)this.openConnection("sms://:1200", 3, false);
            defaultMessagePort.setMessageListener((MessageListener)new WirelessMessageDefaultPortListener(defaultMessagePort));
        }
        catch (IOException e) {
            e.printRealStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Connection openConnection(String url, String protocol, String userInfo, String remoteHost, int remotePort, String remotePath, String remoteQuery, int mode, boolean timeouts) throws IOException {
        if ("file".equalsIgnoreCase(protocol)) {
            if ((mode & 3) != 1) {
                throw new IOException("Connector.open: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b file).");
            }
            if (userInfo != null) {
                if (userInfo.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b file).");
            }
            if (remoteHost != null) {
                if (remoteHost.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b file).");
            }
            if (remotePort != -1) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b file).");
            if (remoteQuery != null) {
                if (remoteQuery.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b file).");
            }
            if (remotePath != null) {
                if (remotePath.length() > 0) return new ReadOnlyFileConnection(url, remotePath);
            }
            remotePath = "/";
            return new ReadOnlyFileConnection(url, remotePath);
        }
        if ("resource".equalsIgnoreCase(protocol)) {
            if ((mode & 3) != 1) {
                throw new IOException("Connector.open: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b resource).");
            }
            if (userInfo != null) {
                if (userInfo.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b resource).");
            }
            if (remoteHost != null) {
                if (remoteHost.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b resource).");
            }
            if (remotePort != -1) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b resource).");
            if (remoteQuery != null) {
                if (remoteQuery.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b resource).");
            }
            if (remotePath != null) {
                if (remotePath.length() > 0) return new ReadOnlyResourceConnection(url, remotePath);
            }
            remotePath = "/";
            return new ReadOnlyResourceConnection(url, remotePath);
        }
        if (!"sms".equalsIgnoreCase(protocol)) throw new ConnectionNotFoundException("Connector.open: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b " + protocol);
        if (userInfo != null) {
            if (userInfo.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b sms).");
        }
        if (remotePath != null) {
            if (remotePath.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b sms).");
        }
        if (remoteQuery != null) {
            if (remoteQuery.length() > 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b sms).");
        }
        if (remoteHost != null && remoteHost.length() > 0) {
            return new ClientMessageConnection(url);
        }
        if (remotePort < 0) throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 (\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b sms).");
        return new ServerMessageConnection(url, remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkAndRegisterInboundConnection(String protocol, int localPort, InboundConnection inboundConnection) throws IOException {
        boolean found;
        if (protocol == null || inboundConnection == null) {
            return;
        }
        QueueOfObjects queueOfObjects = this.events;
        synchronized (queueOfObjects) {
            int len;
            found = false;
            int freedIndex = -1;
            Object[] c = this.inboundConnections;
            int i = len = this.inboundConnections.length;
            while (i-- > 0) {
                InboundConnection connection = c[i];
                if (connection == null) {
                    freedIndex = i;
                    continue;
                }
                try {
                    String connectionProtocol = connection.getProtocol();
                    if (connectionProtocol == null || !protocol.equalsIgnoreCase(connectionProtocol) || localPort != connection.getLocalPort()) continue;
                    found = true;
                    break;
                }
                catch (IOException e) {
                    e.printRealStackTrace();
                }
            }
            if (!found) {
                if (freedIndex < 0) {
                    Object[] objectArray = c;
                    freedIndex = len;
                    this.inboundConnections = new InboundConnection[freedIndex << 1];
                    c = this.inboundConnections;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.inboundConnections, (int)0, (int)freedIndex);
                }
                c[freedIndex] = inboundConnection;
            }
        }
        if (found) {
            throw new IOException("Connector.open: \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u0440\u0442 " + localPort + " \u043f\u043e \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0443 " + protocol + " \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442.");
        }
    }

    protected final URLParser getURLParser() {
        return this.urlParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitEvent() {
        QueueOfObjects monitor;
        QueueOfObjects queueOfObjects = monitor = this.events;
        synchronized (monitor) {
            while (true) {
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                    continue;
                }
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private int indexOfInboundConnection(Connection connection) {
        InboundConnection[] c = this.inboundConnections;
        int i = this.inboundConnections.length;
        while (i-- > 0) {
            if (connection != c[i]) continue;
            return i;
        }
        return -1;
    }
}

