/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.obex;

public class ServerRequestHandler extends Object
{
	private long connectionID;

	protected ServerRequestHandler()
	{
		this.connectionID = -1L;
	}

	public void setConnectionID(long id)
	{
		if(id < -1L || id > 0xffffffffL)
		{
			throw new IllegalArgumentException("ServerRequestHandler.setConnectionID: " +
					"недопустимое значение параметра id.");
		}
		this.connectionID = id;
	}

	public void onAuthenticationFailure(byte[] userName)
	{
	}

	public void onDisconnect(HeaderSet request, HeaderSet reply)
	{
	}

	public int onConnect(HeaderSet request, HeaderSet reply)
	{
		return ResponseCodes.OBEX_HTTP_OK;
	}

	public int onDelete(HeaderSet request, HeaderSet reply)
	{
		return ResponseCodes.OBEX_HTTP_NOT_IMPLEMENTED;
	}

	public int onSetPath(HeaderSet request, HeaderSet reply, boolean backup, boolean create)
	{
		return ResponseCodes.OBEX_HTTP_NOT_IMPLEMENTED;
	}

	public int onPut(Operation operation)
	{
		return ResponseCodes.OBEX_HTTP_NOT_IMPLEMENTED;
	}

	public int onGet(Operation operation)
	{
		return ResponseCodes.OBEX_HTTP_NOT_IMPLEMENTED;
	}

	public long getConnectionID()
	{
		return connectionID;
	}

	public final HeaderSet createHeaderSet()
	{
		return new Headers();
	}
}
