/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.util;

public class QueueOfObjects extends Queue
{
	private static final int INITIAL_CAPACITY = 17;


	protected Object[] queue;

	public QueueOfObjects()
	{
		super(INITIAL_CAPACITY);
		this.queue = new Object[INITIAL_CAPACITY];
	}

	public QueueOfObjects(int capacity)
	{
		super(++capacity);
		this.queue = new Object[capacity];
	}

	public void removeTailElement()
	{
		queue[tail] = null;
		advanceTail();
	}

	public void clear()
	{
		int i;
		int h = head;
		int c = capacity;
		Object[] q = queue;
		for(i = tail; i != h; i = (i + 1) % c)
		{
			q[i] = null;
		}
		super.clear();
	}

	public void push(Object element)
	{
		int nc;
		Object[] q = queue;
		if(getFreeElements() == 0)
		{
			q = queue = expand(q, nc = (capacity << 1) - 1);
			reset(nc);
		}
		q[head] = element;
		advanceHead();
	}

	public Object peek()
	{
		return queue[tail];
	}
}
