/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.time;

public final class ListOfTimeZones extends Object
{
	private static final LocaleTimeZone[] LIST;
	private static final LocaleTimeZone UTC;
	private static final LocaleTimeZone CURRENT;

	static
	{
		int i;
		int ofs;
		String[] utcids;
		LocaleTimeZone[] list;
		LocaleTimeZone ltz;
		LocaleTimeZone cur;
		LocaleTimeZone utc;
		utcids = new String[] {
				"GMT"
		};
		list = new LocaleTimeZone[] {
				null, utc = new LocaleTimeZone(0, "UTC", null, utcids)
		};
		ofs = (int) MalikSystem.syscall(1L, 0x000c);
		cur = null;
		for(i = list.length; i-- > 0; )
		{
			if((ltz = list[i]) != null && ltz.getRawOffset() == ofs)
			{
				cur = ltz;
				break;
			}
		}
		LIST = list;
		UTC = utc;
		CURRENT = cur == null ? (list[0] = new LocaleTimeZone(ofs, buildID(ofs / 60000))) : utc;
	}

	public static int length()
	{
		return LIST.length;
	}

	public static LocaleTimeZone getTimeZone(int index)
	{
		return index >= 0 && index < LIST.length ? LIST[index] : null;
	}

	public static LocaleTimeZone getTimeZone(String id)
	{
		int i;
		LocaleTimeZone result;
		for(i = LIST.length; i-- > 0; )
		{
			if((result = LIST[i]) == null)
			{
				continue;
			}
			if(result.isID(id))
			{
				return result;
			}
		}
		return UTC;
	}

	public static LocaleTimeZone getDefault()
	{
		return CURRENT;
	}

	private static String buildID(int offsetInMinutes)
	{
		StringBuffer result = new StringBuffer("UTC");
		if(offsetInMinutes != 0)
		{
			result.append(offsetInMinutes < 0 ? '-' : '+').
					append((offsetInMinutes = Math.abs(offsetInMinutes)) / 60);
		}
		if((offsetInMinutes % 60) > 0)
		{
			result.append(':').
					append((char) ((offsetInMinutes / 10) + '0')).
					append((char) ((offsetInMinutes % 10) + '0'));
		}
		return result.toString().intern();
	}


	private ListOfTimeZones()
	{
	}
}
