/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.media.sound;

public interface SoundPlayer
{
	public static final int MUTE_VOLUME = 0x00;
	public static final int MAX_VOLUME = 0x7f;
	public static final int FREED = 0;
	public static final int STARTED = 1;
	public static final int STOPPED = 2;

	public void setSoundPlayerListener(SoundPlayerListener listener);

	public void close();

	public int loadBlock(long[] abstractData, int offset, int length);

	public int reset();

	public int start();

	public int stop();

	public int setVolume(int volume);

	public int setCurrentBlockPosition(int position);

	public int getState();

	public int getVolume();

	public int getCurrentBlockPosition();

	public int getCurrentBlockIndex();

	public long getCurrentBlockAndPosition();
}
