/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.media.text;

public final class RasterFont extends Object
{
	private static final RasterFont[] FONTS;

	static
	{
		int handle;
		int count = 0;
		RasterFont[] fonts = new RasterFont[1];
		for(handle = findNextFontHandle(0); handle != 0; handle = findNextFontHandle(handle))
		{
			if(count == fonts.length)
			{
				Array.copy(fonts, 0, fonts = new RasterFont[count << 1], 0, count);
			}
			fonts[count++] = new RasterFont(handle);
		}
		if(count < fonts.length)
		{
			Array.copy(fonts, 0, fonts = new RasterFont[count], 0, count);
		}
		FONTS = fonts;
	}

	public static int getRasterFontsCount()
	{
		return FONTS.length;
	}

	public static RasterFont getRasterFontAtIndex(int index)
	{
		return index >= 0 && index < FONTS.length ? FONTS[index] : null;
	}

	public static RasterFont getRasterFontAtName(String name)
	{
		int i;
		RasterFont font;
		if(name == null)
		{
			return FONTS[0];
		}
		for(i = FONTS.length; i-- > 0; )
		{
			if(name.equals((font = FONTS[i]).name))
			{
				return font;
			}
		}
		return FONTS[0];
	}

	private static int findNextFontHandle(int handle)
	{
		return (int) MalikSystem.syscall((long) handle, 0x0028);
	}


	private boolean bold;
	private boolean italic;
	private int handle;
	private int height;
	private int baselineHeight;
	private int baselinePosition;
	private StringDrawDescriptor stringDescriptor;
	private String name;

	private RasterFont(int handle)
	{
		int h;
		int b;
		int i;
		char[] name;
		i = (int) MalikSystem.syscall((long) handle, 0x002a);
		MalikSystem.syscall(handle, Array.getFirstElementAddress(name =
				new char[(int) MalikSystem.syscall(handle, 0, 0x0029)]), 0x0029);
		this.bold = (i & 0x01) != 0;
		this.italic = (i & 0x02) != 0;
		this.handle = handle;
		this.height = h = (i >> 8) & 0xff;
		this.baselineHeight = b = (i >> 16) & 0xff;
		this.baselinePosition = h - b;
		this.stringDescriptor = new StringDrawDescriptor(handle);
		this.name = new String(name);
	}

	public String toString()
	{
		return "Шрифт[" + name + ", размер=" + height +
				(bold ? ", жирный" : "") + (italic ? ", курсив" : "") + "]";
	}

	public boolean isBold()
	{
		return bold;
	}

	public boolean isItalic()
	{
		return italic;
	}

	public boolean charSupported(int charCode)
	{
		return ((int) MalikSystem.syscall(handle, charCode, 0x002b)) != 0;
	}

	public int charWidth(int charCode)
	{
		int result;
		StringDrawDescriptor s;
		synchronized(s = stringDescriptor)
		{
			s.style = 0x00000000;
			s.length = 1;
			s.chars = MalikSystem.getLocalVariableAddress(charCode);
			result = (int) MalikSystem.syscall((long) s.getDescriptorAddress(), 0x002c);
		}
		return result;
	}

	public int charsWidth(int[] src)
	{
		int result;
		StringDrawDescriptor s;
		if(src == null)
		{
			throw new NullPointerException("RasterFont.charsWidth: " +
					"параметр src равен нулевой ссылке.");
		}
		synchronized(s = stringDescriptor)
		{
			s.style = 0x00000000;
			s.length = src.length;
			s.chars = Array.getFirstElementAddress(src);
			result = (int) MalikSystem.syscall((long) s.getDescriptorAddress(), 0x002c);
		}
		return result;
	}

	public int charsWidth(int[] src, int offset, int length)
	{
		int lim;
		int len;
		int result;
		StringDrawDescriptor s;
		if(src == null)
		{
			throw new NullPointerException("RasterFont.charsWidth: " +
					"параметр src равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = src.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new IndexOutOfBoundsException("RasterFont.charsWidth: " +
					"индекс выходит из диапазона.");
		}
		synchronized(s = stringDescriptor)
		{
			s.style = 0x00000000;
			s.length = length;
			s.chars = Array.getFirstElementAddress(src) + (offset << 2);
			result = (int) MalikSystem.syscall((long) s.getDescriptorAddress(), 0x002c);
		}
		return result;
	}

	public int charsWidth(char[] src)
	{
		int result;
		StringDrawDescriptor s;
		if(src == null)
		{
			throw new NullPointerException("RasterFont.charsWidth: " +
					"параметр src равен нулевой ссылке.");
		}
		synchronized(s = stringDescriptor)
		{
			s.style = 0x80000000;
			s.length = src.length;
			s.chars = Array.getFirstElementAddress(src);
			result = (int) MalikSystem.syscall((long) s.getDescriptorAddress(), 0x002c);
		}
		return result;
	}

	public int charsWidth(char[] src, int offset, int length)
	{
		int lim;
		int len;
		int result;
		StringDrawDescriptor s;
		if(src == null)
		{
			throw new NullPointerException("RasterFont.charsWidth: " +
					"параметр src равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = src.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new IndexOutOfBoundsException("RasterFont.charsWidth: " +
					"индекс выходит из диапазона.");
		}
		synchronized(s = stringDescriptor)
		{
			s.style = 0x80000000;
			s.length = length;
			s.chars = Array.getFirstElementAddress(src) + (offset << 1);
			result = (int) MalikSystem.syscall((long) s.getDescriptorAddress(), 0x002c);
		}
		return result;
	}

	public int stringWidth(String src)
	{
		int result;
		StringDrawDescriptor s;
		if(src == null)
		{
			throw new NullPointerException("RasterFont.stringWidth: " +
					"параметр src равен нулевой ссылке.");
		}
		synchronized(s = stringDescriptor)
		{
			s.style = 0x80000000;
			s.length = src.length();
			s.chars = Array.getFirstElementAddress(src);
			result = (int) MalikSystem.syscall((long) s.getDescriptorAddress(), 0x002c);
		}
		return result;
	}

	public int substringWidth(String src, int offset, int length)
	{
		int lim;
		int len;
		int result;
		StringDrawDescriptor s;
		if(src == null)
		{
			throw new NullPointerException("RasterFont.substringWidth: " +
					"параметр src равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = src.length()) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new IndexOutOfBoundsException("RasterFont.substringWidth: " +
					"индекс выходит из диапазона.");
		}
		synchronized(s = stringDescriptor)
		{
			s.style = 0x80000000;
			s.length = length;
			s.chars = Array.getFirstElementAddress(src) + (offset << 1);
			result = (int) MalikSystem.syscall((long) s.getDescriptorAddress(), 0x002c);
		}
		return result;
	}

	public int getHandle()
	{
		return handle;
	}

	public int getHeight()
	{
		return height;
	}

	public int getBaselineHeight()
	{
		return baselineHeight;
	}

	public int getBaselinePosition()
	{
		return baselinePosition;
	}

	public String getName()
	{
		return name;
	}
}
