/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.io;

import java.io.*;
import malik.emulator.io.j2me.*;

public class Connector extends Object
{
	public static final int READ = 1;
	public static final int WRITE = 2;
	public static final int READ_WRITE = 3;

	public static Connection open(String url)
			throws IOException
	{
		return ImplementationManager.getConnectionFactory().openConnection(url, READ_WRITE, false);
	}

	public static Connection open(String url, int mode)
			throws IOException
	{
		return ImplementationManager.getConnectionFactory().openConnection(url, mode, false);
	}

	public static Connection open(String url, int mode, boolean timeouts)
			throws IOException
	{
		return ImplementationManager.getConnectionFactory().openConnection(url, mode, timeouts);
	}

	public static InputStream openInputStream(String url)
			throws IOException
	{
		InputStream result;
		InputConnection connection = (InputConnection) open(url, READ);
		try
		{
			result = connection.openInputStream();
		}
		finally
		{
			connection.close();
		}
		return result;
	}

	public static OutputStream openOutputStream(String url)
			throws IOException
	{
		OutputStream result;
		OutputConnection connection = (OutputConnection) open(url, WRITE);
		try
		{
			result = connection.openOutputStream();
		}
		finally
		{
			connection.close();
		}
		return result;
	}

	public static DataInputStream openDataInputStream(String url)
			throws IOException
	{
		DataInputStream result;
		InputConnection connection = (InputConnection) open(url, READ);
		try
		{
			result = connection.openDataInputStream();
		}
		finally
		{
			connection.close();
		}
		return result;
	}

	public static DataOutputStream openDataOutputStream(String url)
			throws IOException
	{
		DataOutputStream result;
		OutputConnection connection = (OutputConnection) open(url, WRITE);
		try
		{
			result = connection.openDataOutputStream();
		}
		finally
		{
			connection.close();
		}
		return result;
	}


	private Connector()
	{
	}
}
