/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

final class ChoiceElementDetailsScreen extends StringItem
		implements CommandListener
{
	public static void show(Display display, String title,
			ChoiceElement element, Displayable backScreen)
	{
		Item[] items;
		Command[] commands;
		ChoiceElementDetailsScreen result;
		Form screen;
		Image icon;
		items = new Item[] {
				result = new ChoiceElementDetailsScreen(LAYOUT_VCENTER,
						element.text, element.font, backScreen)
		};
		commands = new Command[] {
				result.backCommand
		};
		screen = new Form(title, null, commands, result, items, null);
		if((icon = element.icon) != null)
		{
			screen.insert(0, new ImageItem(null, icon, LAYOUT_LEFT, null, PLAIN));
		}
		display.setCurrentItem(result);
	}


	private Command backCommand;
	private Displayable backScreen;

	private ChoiceElementDetailsScreen(int layout, String text, Font font, Displayable backScreen)
	{
		super(layout, -1, -1, null, null, null, null, text, font, PLAIN);
		this.backCommand = new Command("Назад", Command.BACK, 0);
		this.backScreen = backScreen;
	}

	public void commandAction(Command command, Displayable screen)
	{
		Display display;
		if(command == backCommand && screen == getOwner())
		{
			display = MIDletProxy.getInstance().getEmulatorScreen();
			if((screen = backScreen) != null && screen.isSystem())
			{
				display.setCurrent(screen);
				return;
			}
			display.hideSystemScreen();
		}
	}

	void onKeyReleased(int key)
	{
		Display display;
		MIDletProxy proxy;
		Displayable screen;
		display = (proxy = MIDletProxy.getInstance()).getEmulatorScreen();
		if(key == proxy.getKeyUsedAs(MIDletProxy.DEVICE_KEY_POUND))
		{
			if((screen = backScreen) != null && screen.isSystem())
			{
				display.setCurrent(screen);
				return;
			}
			display.hideSystemScreen();
			return;
		}
		super.onKeyReleased(key);
	}

	boolean keyHandling(int key)
	{
		return key == MIDletProxy.getInstance().getKeyUsedAs(MIDletProxy.DEVICE_KEY_POUND) ||
				super.keyHandling(key);
	}
}
