/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.media;

public interface PlayerListener
{
	public static final String CLOSED = "closed";
			/* data = null */
	public static final String DEVICE_AVAILABLE = "deviceAvailable";
			/* data = имя устройства как java.lang.String */
	public static final String DEVICE_UNAVAILABLE = "deviceUnavailable";
			/* data = имя устройства как java.lang.String */
	public static final String DURATION_UPDATED = "durationUpdated";
			/* data = продолжительность в микросекундах как java.lang.Long */
	public static final String END_OF_MEDIA = "endOfMedia";
			/* data = продолжительность в микросекундах как java.lang.Long */
	public static final String ERROR = "error";
			/* data = сообщение об ошибке как java.lang.String */
	public static final String STARTED = "started";
			/* data = время от начала медиа в микросекундах как java.lang.Long */
	public static final String STOPPED = "stopped";
			/* data = время от начала медиа в микросекундах как java.lang.Long */
	public static final String VOLUME_CHANGED = "volumeChanged";
			/* data = новая громкость как javax.microedition.media.control.VolumeControl */

	/* новое в JSR-135 */
	public static final String STOPPED_AT_TIME = "stoppedAtTime";
			/* data = время от начала медиа в микросекундах как java.lang.Long */
	public static final String SIZE_CHANGED = "sizeChanged";
			/* data = новые размеры как javax.microedition.media.control.VideoControl */
	public static final String RECORD_STARTED = "recordStarted";
			/* data = время от начала записи в микросекундах как java.lang.Long */
	public static final String RECORD_STOPPED = "recordStopped";
			/* data = время от начала записи в микросекундах как java.lang.Long */
	public static final String RECORD_ERROR = "recordError";
			/* data = сообщение об ошибке как java.lang.String */
	public static final String BUFFERING_STARTED = "bufferingStarted";
			/* data = время от начала медиа в микросекундах как java.lang.Long */
	public static final String BUFFERING_STOPPED = "bufferingStopped";
			/* data = время от начала медиа в микросекундах как java.lang.Long */

	public void playerUpdate(Player player, String event, Object data);
}
