/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.io.j2me;

import java.util.*;

public final class PlayerEventsListenerThread extends Thread
{
	private QueueOfObjects events;

	PlayerEventsListenerThread()
	{
		super("Обработчик событий от проигрывателей");
		this.events = new QueueOfObjects();
	}

	public void run()
	{
		CustomPlayer.Event eventFromPlayer;
		QueueOfObjects queueOfEvents;
		Object monitor = queueOfEvents = events;
		do
		{
			waitEvent();
			if(queueOfEvents.isEmpty())
			{
				continue;
			}
			synchronized(monitor)
			{
				eventFromPlayer = (CustomPlayer.Event) queueOfEvents.peek();
				queueOfEvents.removeTailElement();
			}
			eventFromPlayer.invokePlayerUpdateFromListeners();
		} while(true);
	}

	void pushEvent(CustomPlayer player, String event, Object data)
	{
		QueueOfObjects queueOfEvents;
		Object monitor;
		synchronized(monitor = queueOfEvents = events)
		{
			queueOfEvents.push(player.new Event(event, data));
			monitor.notify();
		}
	}

	private void waitEvent()
	{
		Object monitor;
		synchronized(monitor = events)
		{
			do
			{
				try
				{
					monitor.wait();
					break;
				}
				catch(InterruptedException e)
				{
					e.printRealStackTrace();
				}
			} while(true);
		}
	}
}
