/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.io.j2me;

import java.io.*;
import javax.microedition.io.*;

public interface VirtualConnectionFactory
{
	public static final int PERMISSION_UNKNOWN = -1;
	public static final int PERMISSION_DENIED = 0;
	public static final int PERMISSION_ALLOWED = 1;
	public static final int MODE_READ = 1;
	public static final int MODE_WRITE = 2;
	public static final int MODE_READ_WRITE = 3;

	public void closeConnection(Connection connection)
			throws IOException;

	public void setEvent(Runnable event);

	public void registerConnection(String url, String midlet, String filter)
			throws IOException, ClassNotFoundException;

	public boolean unregisterConnection(String url);

	public boolean platformRequest(String url)
			throws ConnectionNotFoundException;

	public int checkPermission(String permission);

	public String[] listConnections(boolean available);

	public String getFilter(String url);

	public String getMIDlet(String url);

	public InboundConnection getInboundConnection(String protocol, int localPort);

	public Connection openConnection(String url, int mode, boolean timeouts)
			throws IOException;
}
