/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.io.j2me.input;

public final class AvailableInputModes extends Object
{
	private static int COUNT;
	private static InputMode[] MODES;
	private static final Object LOCK;

	static
	{
		InputMode systemInputMode;
		try
		{
			systemInputMode = (InputMode) Class.forName(System.getSystemProperty(
					"malik.emulator.microedition.input.mode.class")).newInstance();
		}
		catch(Exception e)
		{
			systemInputMode = new SystemInputMode();
		}
		LOCK = new Object();
		register(systemInputMode);
	}

	public static void register(InputMode mode)
	{
		if(mode == null)
		{
			return;
		}
		synchronized(LOCK)
		{
			if(MODES == null)
			{
				MODES = new InputMode[16];
			}
			if(COUNT == MODES.length)
			{
				Array.copy(MODES, 0, MODES = new InputMode[COUNT << 1], 0, COUNT);
			}
			MODES[COUNT++] = mode;
		}
	}

	public static int getCount()
	{
		return COUNT;
	}

	public static InputMode getSystemInputMode()
	{
		return MODES[0];
	}

	public static InputMode getInputModeAt(int index)
	{
		return index >= 0 && index < COUNT ? MODES[index] : null;
	}

	public static InputMode getInputMode(String characterSubset)
	{
		int i;
		InputMode mode;
		for(i = COUNT; i-- > 0; )
		{
			if(!(mode = MODES[i]).isCharacterSubset(characterSubset))
			{
				continue;
			}
			return mode;
		}
		return MODES[0];
	}


	private AvailableInputModes()
	{
	}
}
