/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp;

import javax.microedition.lcdui.*;

public class ButtonSet extends CustomItem
{
	private int width;
	private int height;
	private int pressed;
	private int count;
	private int[][] buttons;
	private Image background;
	private Object lock;

	public ButtonSet(int layout, String label, Image buttonsImage)
	{
		this(layout, label, null, null, null, buttonsImage);
	}

	public ButtonSet(int layout, String label,
			Command[] commands, Command defaultCommand, ItemCommandListener listener,
			Image buttonsImage)
	{
		super(layout, -1, -1, label, commands, defaultCommand, listener);
		if(buttonsImage == null)
		{
			throw new NullPointerException("ButtonSet: " +
					"параметр buttonsImage равен нулевой ссылке.");
		}
		this.width = buttonsImage.getWidth() / 2;
		this.height = buttonsImage.getHeight();
		this.pressed = -1;
		this.buttons = new int[1][];
		this.background = buttonsImage;
		this.lock = new Object();
	}

	public void addButton(int buttonID, int left, int top, int width, int height)
	{
		int buttonLeft = Math.max(0, left);
		int buttonTop = Math.max(0, top);
		int buttonRight = Math.min(this.width, left + width);
		int buttonBottom = Math.min(this.height, top + height);
		int len;
		int[][] btns;
		if(buttonLeft >= buttonRight || buttonTop >= buttonBottom)
		{
			return;
		}
		synchronized(lock)
		{
			if((len = this.count) == (btns = this.buttons).length)
			{
				Array.copy(btns, 0, btns = this.buttons = new int[(len << 1) + 1][], 0, len);
			}
			btns[len++] = new int[] {
					buttonID, buttonLeft, buttonTop, buttonRight, buttonBottom
			};
			this.count = len;
		}
	}

	public int getPressedButtonID()
	{
		int p;
		return (p = pressed) >= 0 ? buttons[p][0] : 0;
	}

	protected void paint(Graphics render, int contentWidth, int contentHeight)
	{
		int width = this.width;
		int pressed = this.pressed;
		int left;
		int top;
		int[] button;
		Image background = this.background;
		render.drawRegion(background, 0, 0, width, height, 0, 0, 0, Graphics.LEFT | Graphics.TOP);
		if(pressed >= 0)
		{
			button = buttons[pressed];
			render.drawRegion(background,
					width + (left = button[1]), top = button[2], button[3] - left, button[4] - top,
					0, left, top, Graphics.LEFT | Graphics.TOP);
		}
	}

	protected void pointerPressed(int x, int y)
	{
		int p;
		if((p = getPressedIndex(x, y)) != pressed && p >= 0)
		{
			pressed = p;
			super.notifyStateChanged();
			repaint();
		}
	}

	protected int getMinContentWidth()
	{
		return width;
	}

	protected int getMinContentHeight()
	{
		return height;
	}

	protected int getPrefContentWidth(int contentHeight)
	{
		return width;
	}

	protected int getPrefContentHeight(int contentWidth)
	{
		return height;
	}

	private int getPressedIndex(int x, int y)
	{
		int i;
		int[] button;
		int[][] btns = this.buttons;
		for(i = count; i-- > 0; )
		{
			button = btns[i];
			if(x >= button[1] && y >= button[2] && x < button[3] && y < button[4])
			{
				return i;
			}
		}
		return -1;
	}
}
