/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.player;

import java.io.*;
import javax.microedition.media.*;
import malik.emulator.fileformats.*;
import malik.emulator.io.j2me.*;

public abstract class ContentPlayer extends CustomPlayer
{
	protected ContentPlayer()
	{
	}

	public abstract void close();

	public abstract void start()
			throws MediaException;

	public abstract void stop()
			throws MediaException;

	public abstract void setLoopCount(int loopCount);

	public abstract long setMediaTime(long time)
			throws MediaException;

	public abstract long getMediaTime();

	public abstract long getDuration();

	public abstract void getData(InputStream source)
			throws IOException, InvalidDataFormatException, MediaException;

	protected abstract String getPlayerContentType();
}
