/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package com.samsung.util;

import java.io.*;
import javax.microedition.media.*;
import javax.microedition.media.control.*;
import malik.emulator.io.jar.*;

public class AudioClip extends Object
{
	public static final int TYPE_MMF = 1;
	public static final int TYPE_MP3 = 2;
	public static final int TYPE_MIDI = 3;
	private static final String[] MIME_TYPES;

	static
	{
		MIME_TYPES = new String[] {
				"application/vnd.smaf", "audio/mpeg", "audio/midi"
		};
	}

	public static boolean isSupported()
	{
		return true;
	}


	private Player implement;
	private VolumeControl volume;

	public AudioClip(int type, byte[] src, int offset, int length)
	{
		int lim;
		int len;
		Player implement;
		VolumeControl volume;
		if(--type < 0 || type >= MIME_TYPES.length)
		{
			throw new IllegalArgumentException("AudioClip: " +
					"недопустимое значение параметра type.");
		}
		if(src == null)
		{
			throw new NullPointerException("AudioClip: " +
					"параметр src равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = src.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new ArrayIndexOutOfBoundsException("AudioClip: " +
					"индекс выходит из диапазона.");
		}
		try
		{
			(implement = Manager.createPlayer(new ByteArrayInputStream(src, offset, length),
					MIME_TYPES[type])).prefetch();
			volume = (VolumeControl) implement.getControl("VolumeControl");
		}
		catch(Exception e)
		{
			throw new IllegalArgumentException("AudioClip: " +
					"тип содержимого " + MIME_TYPES[type] + " не поддерживается системой.");
		}
		this.implement = implement;
		this.volume = volume;
	}

	public AudioClip(int type, String resourceName)
			throws IOException
	{
		InputStream source;
		Player implement;
		VolumeControl volume;
		if(--type < 0 || type >= MIME_TYPES.length)
		{
			throw new IllegalArgumentException("AudioClip: " +
					"недопустимое значение параметра type.");
		}
		if(resourceName == null)
		{
			throw new NullPointerException("AudioClip: " +
					"параметр resourceName равен нулевой ссылке.");
		}
		if(resourceName.length() <= 0 || resourceName.charAt(0) != '/')
		{
			resourceName = "/".concat(resourceName);
		}
		if((source = getClass().getResourceAsStream(resourceName)) == null)
		{
			throw new ResourceNotFoundException("AudioClip: " +
					"ресурс " + resourceName + " не найден.");
		}
		try
		{
			(implement = Manager.createPlayer(source, MIME_TYPES[type])).prefetch();
			volume = (VolumeControl) implement.getControl("VolumeControl");
		}
		catch(MediaException e)
		{
			throw new IllegalArgumentException("AudioClip: " +
					"тип содержимого " + MIME_TYPES[type] + " не поддерживается системой.");
		}
		this.implement = implement;
		this.volume = volume;
	}

	public void play(int loopCount, int volumeLevel)
	{
		Player implement;
		VolumeControl volume;
		if(loopCount < 0 || loopCount > 0xff)
		{
			throw new IllegalArgumentException("AudioClip.play: " +
					"недопустимое значение параметра loopCount.");
		}
		if(volumeLevel < 0 || volumeLevel > 5)
		{
			throw new IllegalArgumentException("AudioClip.play: " +
					"недопустимое значение параметра volumeLevel.");
		}
		if(loopCount == 0)
		{
			loopCount = -1;
		}
		try
		{
			if((implement = this.implement) != null)
			{
				implement.stop();
				implement.setLoopCount(loopCount);
				implement.start();
			}
			if((volume = this.volume) != null)
			{
				volume.setLevel(20 * volumeLevel);
			}
		}
		catch(MediaException e)
		{
			e.printRealStackTrace();
		}
	}

	public void resume()
	{
		Player implement;
		try
		{
			if((implement = this.implement) != null)
			{
				implement.start();
			}
		}
		catch(MediaException e)
		{
			e.printRealStackTrace();
		}
	}

	public void pause()
	{
		Player implement;
		try
		{
			if((implement = this.implement) != null)
			{
				implement.stop();
			}
		}
		catch(MediaException e)
		{
			e.printRealStackTrace();
		}
	}

	public void stop()
	{
		Player implement;
		try
		{
			if((implement = this.implement) != null)
			{
				implement.stop();
				implement.setMediaTime(0L);
			}
		}
		catch(MediaException e)
		{
			e.printRealStackTrace();
		}
	}

	protected void $finalize$()
	{
		Player implement;
		if((implement = this.implement) != null)
		{
			implement.close();
		}
	}
}
