/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.io;

public class ByteArrayOutputStream extends OutputStream
{
    protected int count;
    protected byte[] buf;
    private final Object monitor;

    public ByteArrayOutputStream() {
        this.buf = new byte[32];
        this.monitor = new Object();
    }

    public ByteArrayOutputStream(int initialCapacity) {
        if(initialCapacity < 0)
        {
            throw new IllegalArgumentException("ByteArrayOutputStream: аргумент initialCapacity не может быть отрицательным.");
        }
        this.buf = new byte[initialCapacity];
        this.monitor = new Object();
    }

    public void close() throws IOException {
    }

    public void write(int byteData) {
        synchronized(monitor)
        {
            int c;
            byte[] b;
            if((c = count) == (b = buf).length) Array.copy(b, 0, b = buf = new byte[(c << 1) + 1], 0, c);
            b[c++] = (byte) byteData;
            count = c;
        }
    }

    public void write(byte[] src, int offset, int length) {
        if(src == null)
        {
            throw new NullPointerException("ByteArrayOutputStream.write: аргумент src равен нулевой ссылке.");
        }
        Array.checkBound("ByteArrayOutputStream.write", src.length, offset, length);
        if(length <= 0) return;
        synchronized(monitor)
        {
            int c;
            int nc;
            byte[] b;
            if((nc = (c = count) + length) > (b = buf).length) Array.copy(b, 0, b = buf = new byte[Math.max(nc, (c << 1) + 1)], 0, c);
            Array.copy(src, offset, b, c, length);
            count = nc;
        }
    }

    public String toString() {
        String result;
        synchronized(monitor)
        {
            result = new String(buf, 0, count);
        }
        return result;
    }

    public void reset() {
        synchronized(monitor)
        {
            count = 0;
        }
    }

    public int size() {
        return count;
    }

    public byte[] toByteArray() {
        byte[] result;
        synchronized(monitor)
        {
            int c;
            Array.copy(buf, 0, result = new byte[c = count], 0, c);
        }
        return result;
    }
}
