/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package com.nokia.mid.ui;

import javax.microedition.lcdui.*;

public interface DirectGraphics
{
    public static final int FLIP_HORIZONTAL = 0x2000;
    public static final int FLIP_VERTICAL   = 0x4000;
    public static final int ROTATE_90  =  90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    public static final int TYPE_BYTE_1_GRAY_VERTICAL =   -1;
    public static final int TYPE_BYTE_1_GRAY          =    1;
    public static final int TYPE_BYTE_2_GRAY          =    2;
    public static final int TYPE_BYTE_4_GRAY          =    4;
    public static final int TYPE_BYTE_8_GRAY          =    8;
    public static final int TYPE_BYTE_332_RGB         =  332;
    public static final int TYPE_USHORT_444_RGB       =  444;
    public static final int TYPE_USHORT_555_RGB       =  555;
    public static final int TYPE_USHORT_565_RGB       =  565;
    public static final int TYPE_USHORT_1555_ARGB     = 1555;
    public static final int TYPE_USHORT_4444_ARGB     = 4444;
    public static final int TYPE_INT_888_RGB          =  888;
    public static final int TYPE_INT_8888_ARGB        = 8888;

    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int colorARGB);

    public void drawPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int length, int colorARGB);

    public void drawPixels(byte[] pixels, byte[] mask, int offset, int scanlength, int left, int top, int width, int height, int transform, int format);

    public void drawPixels(short[] pixels, boolean transparency, int offset, int scanlength, int left, int top, int width, int height, int transform, int format);

    public void drawPixels(int[] pixels, boolean transparency, int offset, int scanlength, int left, int top, int width, int height, int transform, int format);

    public void drawImage(Image image, int x, int y, int anchor, int transform);

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int colorARGB);

    public void fillPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int length, int colorARGB);

    public void setARGBColor(int colorARGB);

    public void getPixels(byte[] pixels, byte[] mask, int offset, int scanlength, int left, int top, int width, int height, int format);

    public void getPixels(short[] pixels, int offset, int scanlength, int left, int top, int width, int height, int format);

    public void getPixels(int[] pixels, int offset, int scanlength, int left, int top, int width, int height, int format);

    public int getAlphaComponent();

    public int getNativePixelFormat();
}
