/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system.console;

import malik.emulator.microedition.system.*;

public class DoubleOutputConsoleCommand extends ConsoleCommand
{
    public DoubleOutputConsoleCommand() {
        super(
            "дубляж",
            "Использование:\n дубляж\n дубляж вкл\n дубляж выкл\n дубляж откл\nВключает и выключает дублирование вывода через System.out и System.err на консоль.\n" +
            "Отключение дублирования позволяет повысить быстродействие приложения.\nВариант без аргументов выводит на консоль текущее состояние."
        );
    }

    protected void execute(String[] arguments, Console console) {
        if(arguments.length > 0)
        {
            String status = arguments[0];
            if("вкл".equals(status))
            {
                ConsoleOutputStream.setDoubleOutput(true);
            }
            else if("выкл".equals(status) || "откл".equals(status))
            {
                ConsoleOutputStream.setDoubleOutput(false);
            }
        }
        console.println(ConsoleOutputStream.isDoubleOutput() ? "Дублирование вывода включено." : "Дублирование вывода отключено.");
    }
}
