/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.io;

public interface DataInput
{
	public void readFully(byte[] dst)
			throws IOException;

	public void readFully(byte[] dst, int offset, int length)
			throws IOException;

	public boolean readBoolean()
			throws IOException;

	public char readChar()
			throws IOException;

	public float readFloat()
			throws IOException;

	public double readDouble()
			throws IOException;

	public byte readByte()
			throws IOException;

	public short readShort()
			throws IOException;

	public int readUnsignedByte()
			throws IOException;

	public int readUnsignedShort()
			throws IOException;

	public int readInt()
			throws IOException;

	public long readLong()
			throws IOException;

	public String readUTF()
			throws IOException;

	public int skipBytes(int bytesCount)
			throws IOException;
}
