/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.io;

import malik.emulator.i18n.*;

public class OutputStreamWriter extends Writer
{
	private Writer writer;

	public OutputStreamWriter(OutputStream stream)
	{
		if(stream == null)
		{
			throw new NullPointerException("OutputStreamWriter: " +
					"параметр stream равен нулевой ссылке.");
		}
		this.writer = Helper.getStreamWriter(stream);
	}

	public OutputStreamWriter(OutputStream stream, String encoding)
			throws UnsupportedEncodingException
	{
		if(stream == null)
		{
			throw new NullPointerException("OutputStreamWriter: " +
					"параметр stream равен нулевой ссылке.");
		}
		this.writer = Helper.getStreamWriter(stream, encoding);
	}

	public void close()
			throws IOException
	{
		Writer writer;
		if((writer = this.writer) == null)
		{
			return;
		}
		this.writer = null;
		this.lock = null;
		writer.close();
	}

	public void flush()
			throws IOException
	{
		ensureOpen().flush();
	}

	public void write(int src)
			throws IOException
	{
		ensureOpen().write(src);
	}

	public void write(char[] src)
			throws IOException
	{
		if(src == null)
		{
			throw new NullPointerException("OutputStreamWriter.write: " +
					"параметр src равен нулевой ссылке.");
		}
		ensureOpen().write(src);
	}

	public void write(char[] src, int offset, int length)
			throws IOException
	{
		int lim;
		int len;
		if(src == null)
		{
			throw new NullPointerException("OutputStreamWriter.write: " +
					"параметр src равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = src.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new ArrayIndexOutOfBoundsException("OutputStreamWriter.write: " +
					"индекс выходит из диапазона.");
		}
		ensureOpen().write(src, offset, length);
	}

	public void write(String src)
			throws IOException
	{
		if(src == null)
		{
			throw new NullPointerException("OutputStreamWriter.write: " +
					"параметр src равен нулевой ссылке.");
		}
		ensureOpen().write(src);
	}

	public void write(String src, int offset, int length)
			throws IOException
	{
		int lim;
		int len;
		if(src == null)
		{
			throw new NullPointerException("OutputStreamWriter.write: " +
					"параметр src равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = src.length()) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new StringIndexOutOfBoundsException("OutputStreamWriter.write: " +
					"индекс выходит из диапазона.");
		}
		ensureOpen().write(src, offset, length);
	}

	private Writer ensureOpen()
			throws IOException
	{
		Writer result;
		if((result = writer) == null)
		{
			throw new IOException("OutputStreamWriter: " +
					"символьный поток закрыт.");
		}
		return result;
	}
}
