﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.io;

public abstract class Reader extends Object
{
	private static final int MAX_SKIP_BUFFER_SIZE = 0x2000;


	protected Object lock;
	private char[] skipBuffer;

	protected Reader()
	{
		this.lock = this;
	}

	protected Reader(Object lock)
	{
		if(lock == null)
		{
			throw new NullPointerException("Reader: " +
					"параметр lock равен нулевой ссылке.");
		}
		this.lock = lock;
	}

	public abstract void close()
			throws IOException;

	public abstract int read(char[] dst, int offset, int length)
			throws IOException;

	public void reset()
			throws IOException
	{
		throw new IOException("Reader.reset: " +
				"класс " + getClass().getName() + " не поддерживает метод reset.");
	}

	public void mark(int readLimit)
			throws IOException
	{
		throw new IOException("Reader.mark: " +
				"класс " + getClass().getName() + " не поддерживает метод mark.");
	}

	public boolean markSupported()
	{
		return false;
	}

	public boolean ready()
			throws IOException
	{
		return false;
	}

	public int read()
			throws IOException
	{
		char[] result;
		return read(result = new char[1], 0, 1) == -1 ? -1 : (int) result[0];
	}

	public int read(char[] dst)
			throws IOException
	{
		if(dst == null)
		{
			throw new NullPointerException("Reader.read: " +
					"параметр dst равен нулевой ссылке.");
		}
		return read(dst, 0, dst.length);
	}

	public long skip(long charsCount)
			throws IOException
	{
		int nn;
		int nc;
		long r;
		char[] c;
		if(charsCount < 0L)
		{
			throw new IllegalArgumentException("Reader.skip: " +
					"параметр charsCount не может быть отрицательным.");
		}
		nn = (charsCount <= (long) MAX_SKIP_BUFFER_SIZE) ?
				((int) charsCount) : MAX_SKIP_BUFFER_SIZE;
		synchronized(lock)
		{
			if((c = skipBuffer) == null || c.length < nn)
			{
				skipBuffer = c = new char[nn];
			}
			for(r = charsCount; r > 0L; r -= nc)
			{
				if((nc = read(c, 0, (r <= (long) nn) ? ((int) r) : nn)) == -1)
				{
					break;
				}
			}
		}
		return charsCount - r;
	}
}
