﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.i18n.encoding.system;

import java.io.*;
import malik.emulator.i18n.*;

public class UTF_8_Reader extends StreamReader
{
	private static final int NO_BYTE = -2;


	private boolean newRead;
	private int[] readAhead;

	public UTF_8_Reader()
	{
		this.readAhead = new int[] {
				NO_BYTE, NO_BYTE, NO_BYTE
		};
	}

	public void reset()
			throws IOException
	{
		throw new IOException("Reader.reset: " +
				"класс " + getClass().getName() + " не поддерживает метод reset.");
	}

	public void mark(int readlimit)
			throws IOException
	{
		throw new IOException("Reader.mark: " +
				"класс " + getClass().getName() + " не поддерживает метод mark.");
	}

	public boolean markSupported()
	{
		return false;
	}

	public int read(char[] dst, int offset, int length)
			throws IOException
	{
		int result;
		int currentChar;
		int firstByte;
		int extraByte;
		int nextByte;
		int i;
		InputStream stream = ensureOpen();
		if(length == 0)
		{
			return 0;
		}
		newRead = true;
		for(result = 0; result < length; result++)
		{
			if((firstByte = getByteOfCurrentChar(stream, 0)) < 0)
			{
				return firstByte == -1 && result == 0 ? -1 : result;
			}
			switch(firstByte >> 4)
			{
			default:
				throw new UTFDataFormatException("InputStreamReader.read: " +
						"ошибка в данных, закодированных кодировкой UTF-8.");
			case 0x00:
			case 0x01:
			case 0x02:
			case 0x03:
			case 0x04:
			case 0x05:
			case 0x06:
			case 0x07:
				extraByte = 1;
				currentChar = firstByte;
				break;
			case 0x0c:
			case 0x0d:
				extraByte = 2;
				currentChar = firstByte & 0x1f;
				break;
			case 0x0e:
				extraByte = 3;
				currentChar = firstByte & 0x0f;
				break;
			}
			for(i = 1; i < extraByte; i++)
			{
				if((nextByte = getByteOfCurrentChar(stream, i)) == NO_BYTE)
				{
					return result;
				}
				if(nextByte == -1 || (nextByte & 0xc0) != 0x80)
				{
					throw new UTFDataFormatException("InputStreamReader.read: " +
							"ошибка в данных, закодированных кодировкой UTF-8.");
				}
				currentChar = (currentChar << 6) + (nextByte & 0x3f);
			}
			dst[offset + result] = (char) currentChar;
			prepareForNextChar();
		}
		return result;
	}

	public int sizeOf(byte[] src, int offset, int length)
	{
		int result = 0;
		int end;
		for(end = offset + length; end > offset; result++)
		{
			switch((src[offset] & 0xff) >> 4)
			{
			default:
				return result + 1; 
			case 0x00:
			case 0x01:
			case 0x02:
			case 0x03:
			case 0x04:
			case 0x05:
			case 0x06:
			case 0x07:
				offset++;
				break;
			case 0x0c:
			case 0x0d:
				offset += 2;
				break;
			case 0x0e:
				offset += 3;
				break;
			}
		}
		return result;
	}

	private void prepareForNextChar()
	{
		int[] ahead;
		(ahead = readAhead)[0] = NO_BYTE;
		ahead[1] = NO_BYTE;
		ahead[2] = NO_BYTE;
	}

	private int getByteOfCurrentChar(InputStream stream, int byteOfChar)
			throws IOException
	{
		int result;
		int[] ahead;
		if((result = (ahead = readAhead)[byteOfChar]) != NO_BYTE)
		{
			return result;
		}
		if(newRead || stream.available() > 0)
		{
			ahead[byteOfChar] = result = stream.read();
			newRead = false;
			return result;
		}
		return NO_BYTE;
	}
}
