/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.io.vfs;

public class FileAttributes extends Object
{
	/*
	 * Время в формате System.currentTimeMillis()
	 */
	public static final int ATTR_READ_ONLY = 0x0001;
	public static final int ATTR_HIDDEN = 0x0002;
	public static final int ATTR_SYSTEM = 0x0004;
	public static final int ATTR_DIRECTORY = 0x0010;
	public static final int ATTR_ARCHIVE = 0x0020;


	private int attributes;
	private long creationTime;
	private long lastAccessTime;
	private long lastWriteTime;

	public FileAttributes()
	{
	}

	public final void setAttributes(long creationTime, long lastAccessTime, long lastWriteTime,
			boolean readOnly, boolean hidden, boolean system, boolean archive, boolean directory)
	{
		this.attributes =
				(readOnly ? ATTR_READ_ONLY : 0) |
				(hidden ? ATTR_HIDDEN : 0) |
				(system ? ATTR_SYSTEM : 0) |
				(archive ? ATTR_ARCHIVE : 0) |
				(directory ? ATTR_DIRECTORY : 0);
		this.creationTime = creationTime;
		this.lastAccessTime = lastAccessTime;
		this.lastWriteTime = lastWriteTime;
	}

	public final void setAttributes(long creationTime, long lastAccessTime, long lastWriteTime,
			int attributes)
	{
		this.attributes = attributes &
				(ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_ARCHIVE | ATTR_DIRECTORY);
		this.creationTime = creationTime;
		this.lastAccessTime = lastAccessTime;
		this.lastWriteTime = lastWriteTime;
	}

	public final boolean isReadOnly()
	{
		return (attributes & ATTR_READ_ONLY) != 0;
	}

	public final boolean isHidden()
	{
		return (attributes & ATTR_HIDDEN) != 0;
	}

	public final boolean isSystem()
	{
		return (attributes & ATTR_SYSTEM) != 0;
	}

	public final boolean isArchive()
	{
		return (attributes & ATTR_ARCHIVE) != 0;
	}

	public final boolean isDirectory()
	{
		return (attributes & ATTR_DIRECTORY) != 0;
	}

	public final int getAttributes()
	{
		return attributes;
	}

	public final long getCreationTime()
	{
		return creationTime;
	}

	public final long getLastAccessTime()
	{
		return lastAccessTime;
	}

	public final long getLastWriteTime()
	{
		return lastWriteTime;
	}
}
