/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.util;

public final class DataDescriptor extends SystemDescriptor
{
	private int length;
	private int address;
	private int offset;
	private byte[] buffer;

	public DataDescriptor()
	{
	}

	public void setDataInfo(int address, int length)
	{
		this.length = length;
		this.address = address;
		this.offset = 0;
		this.buffer = null;
	}

	public void setDataInfo(byte[] buffer, int offset, int length)
	{
		if(buffer == null)
		{
			throw new NullPointerException("DataDescriptor.setDataInfo: аргумент buffer равен нулевой ссылке.");
		}
		Array.checkBound("DataDescriptor.setDataInfo", buffer.length, offset, length);
		this.length = length;
		this.address = Array.getFirstElementAddress(buffer) + (offset);
		this.offset = offset;
		this.buffer = buffer;
	}

	public int getAddress()
	{
		return address;
	}

	public int getOffset()
	{
		return offset;
	}

	public int getLength()
	{
		return length;
	}

	public byte[] getBuffer()
	{
		return buffer;
	}
}
