﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.fileformats.graphics;

import malik.emulator.fileformats.*;

/**
 * Интерфейс для всех декодеров растровых изображений. Классы, которые поддерживают загрузку в
 * память изображений какого-либо формата (напрмер, BMP, PNG, JPEG), реализуют этот интерфейс.
 * @author Малик Разработчик
 */
public interface ImageDecoder
		extends DataDecoder
{
	/**
	 * Возвращает <code>true</code>, если декодированное изображение поддерживает альфа-канал
	 * (формат пикселов при этом будет <code>0xAARRGGBB</code>), <code>false</code> – если нет
	 * (в этом случае формат пикселов будет <code>0x00RRGGBB</code>).<p />
	 * Возвращаемое значение этой функции неопределено, если декодер пуст.
	 * @return <code>true</code>, если изображение с альфа-каналом, <code>false</code> – если
	 * полностью непрозрачно.
	 * @see ImageDecoder#getPixels()
	 */
	public boolean isAlphaSupported();

	/**
	 * Возвращает ширину декодированного изображения, в пикселах.<p />
	 * Возвращаемое значение этой функции равно нулю, если декодер пуст.
	 * @return ширину изображения.
	 */
	public int getWidth();

	/**
	 * Возвращает высоту декодированного изображения, в пикселах.<p />
	 * Возвращаемое значение этой функции равно нулю, если декодер пуст.
	 * @return высоту изображения.
	 */
	public int getHeight();

	/**
	 * Возвращает массив пикселов декодированного изображения. Длина массива равняется
	 * <code>(getWidth() * getHeight())</code>. Формат пикселов полностью зависит от функции
	 * <code>isAlphaSupported</code>.<p />
	 * Система координат изображения начинается в его верхнем левом углу.
	 * Индекс пиксела с координатами <code>(x, y)</code> вычисляется по формуле:<p />
	 * <code>x + y * getWidth()</code><p />
	 * Будет ли эта функция возвращать один и тот же массив при каждом вызове или каждый раз будет
	 * конструировать новый – полностью зависит от реализации.<p />
	 * Возвращаемое значение этой функции равно нулевой ссылке или массиву нулевой длины, если
	 * декодер пуст.
	 * @return массив пикселов изображения.
	 * @see ImageDecoder#isAlphaSupported()
	 */
	public int[] getPixels();
}
