﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.fileformats.sound.sampled;

import malik.emulator.fileformats.sound.*;

/**
 * Интерфейс для всех декодеров звука, основанного на импульсно-кодовой модуляции (ИКМ).
 * Классы, которые поддерживают загрузку в память звука какого-либо формата
 * (например, WAV, OGG, AMR), реализуют этот интерфейс.
 * @author Малик Разработчик
 */
public interface SoundDecoderSampled
		extends SoundDecoder
{
	/**
	 * Возвращает количество каналов декодированного звука. Для звуков типа «моно» возвращает 1,
	 * для «стерео» – возвращает 2, однако количество каналов может превышать 2.<p />
	 * Возвращаемое значение этой функции равно нулю, если декодер пуст.
	 * @return количество каналов.
	 */
	public int getChannels();

	/**
	 * Возвращает количество отсчётов декодированного звукового сигнала в секунду
	 * (частоту дискретизации), в герцах.
	 * Типичные возвращаемые значения обычно равны 8000, 16000, 48000, 11025, 22050 или 44100 Гц.
	 * Эти частоты наиболее эффективны, поскольку чаще всего реализуются на аппаратном
	 * уровне.<p />
	 * Возвращаемое значение этой функции равно нулю, если декодер пуст.
	 * @return количество отсчётов в секунду.
	 */
	public int getSamplesPerSecond();

	/**
	 * Возвращает массив отсчётов декодированного звукового сигнала. Длина этого массива прямо
	 * пропорциональна времени звучания и кратна количеству каналов.<p />
	 * Индекс <i>i</i>-го отсчёта для <i>j</i>-го канала (<i>i</i> отсчитывается от 0,
	 * <code>1</code> &#8804; <i>j</i> &#8804; <code>getChannels()</code>) вычисляется по
	 * формуле:<p />
	 * <code>i * getChannels() + j - 1</code><p />
	 * Длительность звучания в миллисекундах вычисляется по формуле:<p />
	 * <code>1000L * ((long) getSamples().length) /
	 * ((long) (getChannels() * getSamplesPerSecond()))</code><p />
	 * Будет ли эта функция возвращать один и тот же массив при каждом вызове или каждый раз будет
	 * конструировать новый – полностью зависит от реализации.<p />
	 * Возвращаемое значение этой функции равно нулевой ссылке или массиву нулевой длины, если
	 * декодер пуст.
	 * @return массив отсчётов звукового сигнала.
	 */
	public short[] getSamples();
}
