/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

import malik.emulator.media.graphics.*;

public class ImageItem extends Item
{
	public static final int LAYOUT_DEFAULT = 0x0000;
	public static final int LAYOUT_LEFT = 0x0001;
	public static final int LAYOUT_RIGHT = 0x0002;
	public static final int LAYOUT_CENTER = 0x0003;
	public static final int LAYOUT_NEWLINE_BEFORE = 0x0100;
	public static final int LAYOUT_NEWLINE_AFTER = 0x0200;


	private boolean controlFocused;
	private boolean pointerFocused;
	private boolean pointerPressed;
	private int contentWidth;
	private int contentHeight;
	private int appearance;
	private Image image;
	private String altText;

	public ImageItem(String label, Image image, int layout, String altText)
	{
		this(layout, label, null, null, null, image, altText, PLAIN);
	}

	public ImageItem(String label, Image image, int layout, String altText, int appearance)
	{
		this(layout, label, null, null, null, image, altText, appearance);
	}

	public ImageItem(int layout, String label,
			Command[] commands, Command defaultCommand, ItemCommandListener listener,
			Image image, String altText, int appearance)
	{
		super(layout, -1, -1, label, commands, defaultCommand, listener);
		if(appearance != PLAIN && appearance != HYPERLINK && appearance != BUTTON)
		{
			throw new IllegalArgumentException("ImageItem: " +
					"недопустимое значение параметра appearance.");
		}
		this.appearance = appearance;
		this.image = image != null ? Image.createImage(image) : null;
		this.altText = altText;
	}

	public void setLayout(int layout)
	{
		super.setLayout(layout);
	}

	public int getLayout()
	{
		return super.getLayout();
	}

	public void setImage(Image image)
	{
		this.image = image != null ? Image.createImage(image) : null;
		notifyUpdate();
	}

	public void setAltText(String altText)
	{
		this.altText = altText;
	}

	public int getAppearanceMode()
	{
		return appearance;
	}

	public Image getImage()
	{
		return image;
	}

	public String getAltText()
	{
		return altText;
	}

	void paintContent(Graphics render, int contentWidth, int contentHeight)
	{
		boolean pressed;
		int l;
		int t;
		int a;
		int w;
		int h;
		Image image;
		if((image = this.image) == null)
		{
			return;
		}
		pressed = pointerPressed;
		w = image.getWidth();
		h = image.getHeight();
		if(isMatchForButton())
		{
			render.drawElementOfGUI(4, pressed ? 1 : (controlFocused ? 3 : 0), 0,
					0, 0, contentWidth, contentHeight);
			l = ((contentWidth - w) / 2) + (pressed ? 1 : 0);
			t = ((contentHeight - h) / 2) + (pressed ? 1 : 0);
			a = Graphics.LEFT | Graphics.TOP;
		}
		else if(isMatchForHyperlink())
		{
			a = pressed ? 1 : (controlFocused ? 3 : 0);
			render.setColor(RasterCanvas.getSystemColor(a + 0x24));
			render.drawRect(0, 0, contentWidth - 1, contentHeight - 1);
			render.drawRect(1, 1, contentWidth - 3, contentHeight - 3);
			l = ((contentWidth - w) / 2) + (pressed ? 1 : 0);
			t = ((contentHeight - h) / 2) + (pressed ? 1 : 0);
			a = Graphics.LEFT | Graphics.TOP;
		}
		else
		{
			l = pressed ? 5 : 4;
			t = pressed ? 5 : 4;
			a = Graphics.LEFT | Graphics.TOP;
		}
		render.drawImage(image, l, t, a);
	}

	void onSizeChanged(int contentWidth, int contentHeight)
	{
		this.contentWidth = contentWidth;
		this.contentHeight = contentHeight;
	}

	void onContentPointerPressed(int x, int y, int button)
	{
		if(button != MIDletProxy.BUTTON_MAIN ||
				(!isMatchForButton()) && (!isMatchForHyperlink()))
		{
			return;
		}
		pointerFocused = true;
		pointerPressed = true;
		notifyPaint();
	}

	void onContentPointerDragged(int x, int y)
	{
		if((!pointerFocused) || pointerPressed == (pointerPressed =
				x >= 0 && x < contentWidth &&
				y >= 0 && y < contentHeight))
		{
			return;
		}
		notifyPaint();
	}

	void onContentPointerReleased(int x, int y, int button)
	{
		boolean pressed;
		if(button != MIDletProxy.BUTTON_MAIN)
		{
			return;
		}
		pressed = pointerPressed;
		pointerFocused = false;
		pointerPressed = false;
		if(!pressed)
		{
			return;
		}
		notifyPaint();
		notifyCommandAction(getCommands().getDefaultCommand());
	}

	void onTraverseOut()
	{
		controlFocused = false;
		if(isMatchForButton())
		{
			notifyPaint();
		}
	}

	boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight,
			int[] visibleRectangle)
	{
		boolean cfocused;
		int tmp;
		int size;
		if((cfocused = controlFocused) != (controlFocused = true) && isMatchForButton())
		{
			notifyPaint();
		}
		if(pointerFocused)
		{
			return true;
		}
		switch(direction)
		{
		case Canvas.UP:
			if(cfocused)
			{
				if((tmp = visibleRectangle[TOP]) > 0)
				{
					visibleRectangle[TOP] = Math.max(tmp - viewportHeight / 4, 0);
					return true;
				}
				return false;
			}
			break;
		case Canvas.LEFT:
			if(cfocused)
			{
				if((tmp = visibleRectangle[LEFT]) > 0)
				{
					visibleRectangle[LEFT] = Math.max(tmp - viewportWidth / 4, 0);
					return true;
				}
				return false;
			}
			break;
		case Canvas.RIGHT:
			size = super.getPreferredWidth() - visibleRectangle[WIDTH];
			if(cfocused)
			{
				if((tmp = visibleRectangle[LEFT]) < size)
				{
					visibleRectangle[LEFT] = Math.min(tmp + viewportWidth / 4, size);
					return true;
				}
				return false;
			}
			break;
		case Canvas.DOWN:
			size = super.getPreferredHeight() - visibleRectangle[HEIGHT];
			if(cfocused)
			{
				if((tmp = visibleRectangle[TOP]) < size)
				{
					visibleRectangle[TOP] = Math.min(tmp + viewportHeight / 4, size);
					return true;
				}
				return false;
			}
			break;
		}
		return true;
	}

	boolean isMatchForButton()
	{
		return appearance == BUTTON && super.isMatchForButton();
	}

	boolean isMatchForHyperlink()
	{
		return appearance == HYPERLINK && super.isMatchForHyperlink();
	}

	int getPreferredContentWidth(int contentHeight, int containerClientWidth)
	{
		Image image;
		return (image = this.image) != null ? image.getWidth() + 8 : 0;
	}

	int getPreferredContentHeight(int contentWidth)
	{
		Image image;
		return (image = this.image) != null ? image.getHeight() + 8 : 0;
	}
}
