/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public class Ticker extends Object
{
	private static final char SPACE = ' ';
	private static final int SPEED = 4;

	private static String toDisplayed(String text)
	{
		int i;
		int len;
		StringBuffer result;
		if(text == null || (len = text.length()) == 0)
		{
			return "";
		}
		result = new StringBuffer(text);
		for(i = len; i-- > 0; )
		{
			if(result.charAt(i) < SPACE)
			{
				result.setCharAt(i, SPACE);
				result.insert(i, SPACE);
			}
		}
		return result.toString();
	}


	private int limit;
	private int start;
	private int position;
	private Object lock;
	private String text;
	private String displayed;

	public Ticker(String text)
	{
		int s;
		Display display;
		String displayed = toDisplayed(text);
		this.limit = -(display = MIDletProxy.getInstance().getEmulatorScreen()).getGUIElementFont(
				Displayable.GUI_ELEMENT_TICKER).stringWidth(displayed);
		this.start = s = display.getWidth();
		this.position = s;
		this.lock = new Object();
		this.text = text;
		this.displayed = displayed;
	}

	public void setString(String text)
	{
		int limit;
		String displayed = toDisplayed(text);
		limit = -MIDletProxy.getInstance().getEmulatorScreen().getGUIElementFont(
				Displayable.GUI_ELEMENT_TICKER).stringWidth(displayed);
		synchronized(lock)
		{
			this.limit = limit;
			this.position = start;
		}
		this.text = text;
		this.displayed = displayed;
	}

	public String getString()
	{
		return text;
	}

	public final int getPosition()
	{
		return position;
	}

	public final String getDisplayedText()
	{
		return displayed;
	}

	final void scroll()
	{
		int p;
		synchronized(lock)
		{
			if((p = position - SPEED) <= limit)
			{
				p = start - SPEED;
			}
			position = p;
		}
	}
}
