/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.application;

public abstract class Requestable extends Object
{
    public static final int ACTION_VIRTUAL_0 = 0x00;
    public static final int ACTION_VIRTUAL_1 = 0x04;
    public static final int ACTION_VIRTUAL_2 = 0x08;
    public static final int ACTION_VIRTUAL_3 = 0x0c;
    public static final int ACTION_WINDOW_RESIZE = 0x01;
    public static final int ACTION_WINDOW_SHOW = 0x02;
    public static final int ACTION_WINDOW_HIDE = 0x03;
    public static final int ACTION_KEY_REPEATED = 0x05;
    public static final int ACTION_KEY_PRESSED = 0x06;
    public static final int ACTION_KEY_RELEASED = 0x07;
    public static final int ACTION_POINTER_DRAGGED = 0x09;
    public static final int ACTION_POINTER_PRESSED = 0x0a;
    public static final int ACTION_POINTER_RELEASED = 0x0b;
    public static final int ACTION_BUTTON_PRESSED = 0x0e;
    public static final int ACTION_BUTTON_RELEASED = 0x0f;

    private boolean terminated;

    protected Requestable() {
    }

    public abstract void request(int action, int param1, int param2, int param3);

    public abstract void request(Runnable action, long delay);

    public void request(Runnable action) {
        request(action, 0L);
    }

    public void terminate() {
        terminated = true;
    }

    public final void requestWindowShow() {
        request(ACTION_WINDOW_SHOW, 0, 0, 0);
    }

    public final void requestWindowHide() {
        request(ACTION_WINDOW_HIDE, 0, 0, 0);
    }

    public final void requestWindowResize(int width, int height) {
        request(ACTION_WINDOW_RESIZE, 0, width, height);
    }

    public final void requestKeyboardEvent(int action, int key, int charCode) {
        if(action != ACTION_KEY_REPEATED && action != ACTION_KEY_PRESSED && action != ACTION_KEY_RELEASED)
        {
            throw new IllegalArgumentException("Requestable.requestKeyboardEvent: аргумент action имеет недопустимое значение.");
        }
        request(action, key, charCode & 0xffff, charCode >>> 0x10);
    }

    public final void requestPointerEvent(int action, int button, int rawX, int rawY) {
        if(action != ACTION_POINTER_DRAGGED && action != ACTION_POINTER_PRESSED && action != ACTION_POINTER_RELEASED && action != ACTION_BUTTON_PRESSED && action != ACTION_BUTTON_RELEASED)
        {
            throw new IllegalArgumentException("Requestable.requestPointerEvent: аргумент action имеет недопустимое значение.");
        }
        request(action, button, rawX, rawY);
    }

    public final boolean terminated() {
        return terminated;
    }
}
