/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.i18n.encoding.system;

import java.io.*;
import malik.emulator.i18n.*;

public class UTF_8_Writer extends StreamWriter
{
    private static void writeCharacter(OutputStream stream, int character) throws IOException {
        if(character > 0 && character <= 0x007f)
        {
            stream.write(character);
            return;
        }
        if(character <= 0x07ff)
        {
            stream.write(0xc0 + ((character >> 6) & 0x1f));
            stream.write(0x80 + (character & 0x3f));
            return;
        }
        stream.write(0xe0 + ((character >> 12) & 0x0f));
        stream.write(0x80 + ((character >> 6) & 0x3f));
        stream.write(0x80 + (character & 0x3f));
    }

    public UTF_8_Writer() {
        super(new Object());
    }

    public void write(int charData) throws IOException {
        OutputStream stream = getOutputStream();
        synchronized(lock)
        {
            writeCharacter(stream, charData);
        }
    }

    public void write(char[] src, int offset, int length) throws IOException {
        OutputStream stream = getOutputStream();
        synchronized(lock)
        {
            for(int lim = offset + length; offset < lim; offset++) writeCharacter(stream, src[offset]);
        }
    }

    public void write(String string) throws IOException {
        OutputStream stream = getOutputStream();
        synchronized(lock)
        {
            for(int len = string == null ? 0 : string.length(), i = 0; i < len; i++) writeCharacter(stream, string.charAt(i));
        }
    }

    public void write(String string, int offset, int length) throws IOException {
        OutputStream stream = getOutputStream();
        synchronized(lock)
        {
            for(int lim = offset + length; offset < lim; offset++) writeCharacter(stream, string.charAt(offset));
        }
    }
}
