/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.media.graphics;

public final class PrimitiveRender extends Object
{
    private int x;
    private int y;
    private final long address;
    private final RasterBufferDescriptor source;
    private final StretchDrawDescriptor descriptor;

    PrimitiveRender(RasterBufferDescriptor source, StretchDrawDescriptor descriptor) {
        this.address = (long) descriptor.getDescriptorAddress();
        this.source = source;
        this.descriptor = descriptor;
    }

    public void drawPixel(int x, int y) {
        descriptor.assignStretch(source, RasterCanvas.TRANSFORM_NONE, this.x + x, this.y + y, 1, 1);
        MalikSystem.syscall(address, 0x0027);
    }

    public void drawHorizontalLine(int x, int y, int length) {
        if(length < 0) x -= (length = -length);
        descriptor.assignStretch(source, RasterCanvas.TRANSFORM_NONE, this.x + x, this.y + y, length, 1);
        MalikSystem.syscall(address, 0x0027);
    }

    public void drawVerticalLine(int x, int y, int length) {
        if(length < 0) y -= (length = -length);
        descriptor.assignStretch(source, RasterCanvas.TRANSFORM_NONE, this.x + x, this.y + y, 1, length);
        MalikSystem.syscall(address, 0x0027);
    }

    public void fillRectangle(int left, int top, int width, int height) {
        if(width < 0) left -= (width = -width);
        if(height < 0) top -= (height = -height);
        descriptor.assignStretch(source, RasterCanvas.TRANSFORM_NONE, this.x + left, this.y + top, width, height);
        MalikSystem.syscall(address, 0x0027);
    }

    public void fillRectangle(Rectangle region) {
        int left;
        int top;
        int width;
        int height;
        if(region == null) return;
        left = region.getLeft();
        top = region.getTop();
        width = region.getWidth();
        height = region.getHeight();
        if(width < 0) left -= (width = -width);
        if(height < 0) top -= (height = -height);
        descriptor.assignStretch(source, RasterCanvas.TRANSFORM_NONE, this.x + left, this.y + top, width, height);
        MalikSystem.syscall(address, 0x0027);
    }

    void setCoordinates(int x, int y) {
        this.x = x;
        this.y = y;
    }
}
