/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

import malik.emulator.application.*;

public abstract class AppearanceModeItem extends FocusItem
{
    boolean pressed;
    int contentWidth;
    int contentHeight;
    final int appearanceMode;

    AppearanceModeItem(String label, int appearanceMode) {
        this(label, LAYOUT_DEFAULT, appearanceMode);
    }

    AppearanceModeItem(String label, int layout, int appearanceMode) {
        super(label, layout);
        if(appearanceMode < PLAIN || appearanceMode > BUTTON)
        {
            throw new IllegalArgumentException("AppearanceModeItem: аргумент appearanceMode имеет недопустимое значение.");
        }
        this.appearanceMode = appearanceMode;
    }

    public int getAppearanceMode() {
        return appearanceMode;
    }

    abstract void paint(Graphics render, int contentWidth, int contentHeight);

    abstract int getMinimumContentWidth();

    abstract int getMinimumContentHeight();

    void onSizeChanged(int contentWidth, int contentHeight) {
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
    }

    void onKeyboardEvent(KeyboardEvent event) {
        if(appearanceMode != PLAIN && event.getKey() == KeyboardEvent.KEY_SPACE)
        {
            switch(event.getAction())
            {
            case KeyboardEvent.ACTION_KEY_PRESSED:
                pressed = true;
                requestPaint();
                break;
            case KeyboardEvent.ACTION_KEY_RELEASED:
                if(pressed)
                {
                    pressed = false;
                    requestPaint();
                    requestDefaultCommandAction();
                }
                break;
            }
        }
    }

    void onPointerEvent(PointerEvent event) {
        if(appearanceMode != PLAIN)
        {
            if(event.getAction() != PointerEvent.ACTION_POINTER_RELEASED)
            {
                int x = event.getX();
                int y = event.getY();
                if(pressed != (pressed = x >= 0 && x < contentWidth && y >= 0 && y < contentHeight)) requestPaint();
            }
            else if(pressed)
            {
                pressed = false;
                requestPaint();
                requestDefaultCommandAction();
            }
        }
    }
}
