/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

import malik.emulator.media.graphics.*;

public class ImageItem extends AppearanceModeItem
{
    public static final int LAYOUT_DEFAULT = 0x0000;
    public static final int LAYOUT_LEFT = 0x0001;
    public static final int LAYOUT_RIGHT = 0x0002;
    public static final int LAYOUT_CENTER = 0x0003;
    public static final int LAYOUT_NEWLINE_BEFORE = 0x0100;
    public static final int LAYOUT_NEWLINE_AFTER = 0x0200;

    private String altText;
    private Image image;

    public ImageItem(String label, Image image, int layout, String altText) {
        this(label, image, layout, altText, PLAIN);
    }

    public ImageItem(String label, Image image, int layout, String altText, int appearanceMode) {
        super(label, layout, appearanceMode);
        this.altText = altText;
        this.image = image;
    }

    public void setLayout(int layout) {
        super.setLayout(layout);
    }

    public int getLayout() {
        return super.getLayout();
    }

    public void setImage(Image image) {
        this.image = image == null ? null : Image.createImage(image);
        requestInvalidate();
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public Image getImage() {
        return image;
    }

    public String getAltText() {
        return altText;
    }

    void paint(Graphics render, int contentWidth, int contentHeight) {
        boolean p;
        int l;
        int t;
        int w;
        int h;
        Image content;
        if((content = image) == null) return;
        switch(appearanceMode)
        {
        default:
            l = t = 0;
            w = contentWidth;
            h = contentHeight;
            break;
        case HYPERLINK:
            l = t = (p = pressed) ? 5 : 4;
            w = contentWidth > 8 ? contentWidth - 8 : 0;
            h = contentHeight > 8 ? contentHeight - 8 : 0;
            render.setColor(RasterCanvas.getSystemColor(focused ? p ? 0x25 : 0x27 : 0x24));
            render.drawRect(0, 0, contentWidth - 1, contentHeight - 1);
            render.drawRect(1, 1, contentWidth - 3, contentHeight - 3);
            break;
        case BUTTON:
            l = t = (p = pressed) ? 5 : 4;
            w = contentWidth > 8 ? contentWidth - 8 : 0;
            h = contentHeight > 8 ? contentHeight - 8 : 0;
            render.drawElement(4, focused ? p ? 1 : 3 : 0, 0, 0, 0, contentWidth, contentHeight);
            break;
        }
        render.drawImage(content, l + ((w - content.width) >> 1), t + ((h - content.height) >> 1), 0);
    }

    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        int max;
        int pos1;
        int pos2;
        int size;
        int delta;
        if(!super.onFocusMove(direction, viewportWidth, viewportHeight, visibleRectangle))
        {
            pressed = false;
            return true;
        }
        switch(direction)
        {
        default:
            break;
        case DIR_LEFT:
            if((pos1 = visibleRectangle[LEFT]) <= 0) return false;
            visibleRectangle[LEFT] = pos1 > (delta = viewportWidth >> 1) ? pos1 - delta : 0;
            break;
        case DIR_RIGHT:
            if((pos2 = (pos1 = visibleRectangle[LEFT]) + (size = visibleRectangle[WIDTH])) >= (max = contentWidth)) return false;
            visibleRectangle[LEFT] = pos2 < max - (delta = viewportWidth >> 1) ? pos1 + delta : max - size;
            break;
        case DIR_UP:
            if((pos1 = visibleRectangle[TOP]) <= 0) return false;
            visibleRectangle[TOP] = pos1 > (delta = viewportHeight >> 1) ? pos1 - delta : 0;
            break;
        case DIR_DOWN:
            if((pos2 = (pos1 = visibleRectangle[TOP]) + (size = visibleRectangle[HEIGHT])) >= (max = contentHeight)) return false;
            visibleRectangle[TOP] = pos2 < max - (delta = viewportHeight >> 1) ? pos1 + delta : max - size;
            break;
        }
        return true;
    }

    int getMinimumContentWidth() {
        Image content;
        return (content = image) == null ? 0 : content.width + sizeAppendix();
    }

    int getMinimumContentHeight() {
        Image content;
        return (content = image) == null ? 0 : content.height + sizeAppendix();
    }

    private int sizeAppendix() {
        switch(appearanceMode)
        {
        default:
            return 0;
        case HYPERLINK:
        case BUTTON:
            return 8;
        }
    }
}
