/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system;

import javax.microedition.lcdui.*;
import malik.emulator.microedition.lcdui.*;

public class SettingsForm extends Form
{
    private static Item[] concatItems(Item item1, Item item2, Item[] items, Item item3, Item item4) {
        int dstLen;
        int srcLen = items != null ? items.length : 0;
        Item[] result = new Item[dstLen = 4 + srcLen];
        if(srcLen > 0) Array.copy(items, 0, result, 2, srcLen);
        result[0] = item1;
        result[1] = item2;
        result[dstLen - 2] = item3;
        result[dstLen - 1] = item4;
        return result;
    }

    private static Item createHelpSeparator() {
        Item result;
        (result = new Spacer(0, 0)).setLayout(Item.LAYOUT_NEWLINE_AFTER);
        return result;
    }

    private static Item createHelpShowButton() {
        StringItem result;
        Font font = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN, Font.SIZE_SMALL);
        (result = new StringItem(null, "Справка >", Item.BUTTON)).setFont(font);
        result.setLayout(Item.LAYOUT_LEFT);
        result.setDefaultCommand(List.SELECT_COMMAND);
        return result;
    }

    private static Item createHelpHideButton() {
        StringItem result;
        Font font = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN, Font.SIZE_SMALL);
        (result = new StringItem(null, "< Скрыть справку", Item.BUTTON)).setFont(font);
        result.setLayout(Item.LAYOUT_RIGHT | Item.LAYOUT_NEWLINE_AFTER);
        result.setDefaultCommand(List.SELECT_COMMAND);
        return result;
    }

    private static StringItem createBackButton() {
        StringItem result;
        Font font = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, Font.SIZE_SMALL);
        (result = new StringItem(null, "Назад", Item.BUTTON)).setFont(font);
        result.setLayout(Item.LAYOUT_NEWLINE_AFTER | Item.LAYOUT_RIGHT);
        result.setDefaultCommand(List.SELECT_COMMAND);
        return result;
    }

    private static StringItem createApplyButton() {
        StringItem result;
        Font font = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, Font.SIZE_SMALL);
        (result = new StringItem(null, "Применить", Item.BUTTON)).setFont(font);
        result.setLayout(Item.LAYOUT_NEWLINE_BEFORE | Item.LAYOUT_RIGHT);
        result.setDefaultCommand(List.SELECT_COMMAND);
        return result;
    }

    private static StringItem createHelpContents() {
        StringItem result;
        Font font = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN, Font.SIZE_SMALL);
        (result = new StringItem("Справка", null, Item.PLAIN)).setFont(font);
        result.setLayout(Item.LAYOUT_NEWLINE_AFTER | Item.LAYOUT_EXPAND);
        return result;
    }

    private boolean helpOpened;
    final Item helpShowButton;
    final Item helpHideButton;
    private final Item helpSeparator;
    private final StringItem helpContents;
    private final StringItem applyButton;
    private final StringItem backButton;

    public SettingsForm(String title) {
        this(title, null, false, null, null);
    }

    public SettingsForm(String title, Item[] items) {
        this(title, null, false, null, items);
    }

    public SettingsForm(String title, Ticker ticker, boolean fullScreen, ScrollBarStyle style, Item[] items) {
        super(title, ticker, fullScreen, style, concatItems(createHelpShowButton(), createHelpSeparator(), items, createApplyButton(), createBackButton()));
        int len = super.size();
        ItemCommandListener listener = new ItemCommandListener() {
            public void commandAction(Command command, Item item) {
                SettingsForm parent = SettingsForm.this;
                if(item == parent.helpShowButton)
                {
                    parent.showHelp();
                }
                else if(item == parent.helpHideButton)
                {
                    parent.hideHelp();
                    parent.getVerticalScrollBar().setPosition(0);
                }
            }
        };
        Item helpShowButton = super.get(0);
        Item helpHideButton = createHelpHideButton();
        helpShowButton.setItemCommandListener(listener);
        helpHideButton.setItemCommandListener(listener);
        this.helpShowButton = helpShowButton;
        this.helpHideButton = helpHideButton;
        this.helpSeparator = super.get(1);
        this.helpContents = createHelpContents();
        this.applyButton = (StringItem) super.get(len - 2);
        this.backButton = (StringItem) super.get(len - 1);
    }

    public void insert(int itemIndex, Item item) {
        super.insert(itemIndex < 0 || itemIndex > super.size() - 4 ? -1 : itemIndex + 2, item);
    }

    public void delete(int itemIndex) {
        super.delete(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2);
    }

    public void deleteAll() {
        super.deleteAll();
        if(helpOpened)
        {
            super.append(helpContents);
            super.append(helpHideButton);
        } else
        {
            super.append(helpShowButton);
            super.append(helpSeparator);
        }
        super.append(applyButton);
        super.append(backButton);
    }

    public void set(int itemIndex, Item item) {
        super.set(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2, item);
    }

    public int size() {
        return super.size() - 4;
    }

    public int append(Item item) {
        int result = super.size() - 4;
        super.insert(result + 2, item);
        return result;
    }

    public Item get(int itemIndex) {
        return super.get(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2);
    }

    public void setButtonListener(ItemCommandListener listener) {
        applyButton.setItemCommandListener(listener);
        backButton.setItemCommandListener(listener);
    }

    public void setHelpContents(String help) {
        helpContents.setText(help);
    }

    public String getHelpContents() {
        return helpContents.getText();
    }

    public StringItem getHelpContentsItem() {
        return helpContents;
    }

    public StringItem getApplyButton() {
        return applyButton;
    }

    public StringItem getBackButton() {
        return backButton;
    }

    final void showHelp() {
        helpOpened = true;
        super.set(0, helpContents);
        super.set(1, helpHideButton);
    }

    final void hideHelp() {
        helpOpened = false;
        super.set(0, helpShowButton);
        super.set(1, helpSeparator);
    }
}
