/*
    Редактор шрифтов UFN
    Эта программа создана специально для программы Малик Эмулятор.

    Copyright © 2019, 2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package ru.malik.elaborarer.ufneditor;

import javax.microedition.lcdui.*;
import malik.emulator.fileformats.font.*;
import malik.emulator.fileformats.font.UnicodeRasterFont.*;

public final class FontPreview extends FontCustomItem
{
    private boolean underline;
    private boolean strikeout;
    private String string;

    public FontPreview(UnicodeRasterFont font) {
        super(font);
    }

    public void notifyFontChanged() {
        repaint();
    }

    public void setUnderline(boolean underline) {
        if(this.underline != (this.underline = underline)) repaint();
    }

    public void setStrikeout(boolean strikeout) {
        if(this.strikeout != (this.strikeout = strikeout)) repaint();
    }

    public void setString(String string) {
        String oldString;
        if((oldString = this.string) == null ? string != null : !oldString.equals(string))
        {
            this.string = string;
            repaint();
        }
    }

    public boolean isUnderline() {
        return underline;
    }

    public boolean isStrikeout() {
        return strikeout;
    }

    public String getString() {
        return string;
    }

    protected void paint(Graphics render, int contentWidth, int contentHeight) {
        boolean s;
        boolean u;
        int p = 0;
        char[] chars;
        String string;
        UnicodeRasterFont font = this.font;
        chars = (string = this.string) != null ? string.toCharArray() : new char[0];
        render.setColor(0xffffff);
        render.fillRect(0, 0, contentWidth, contentHeight);
        render.setColor(0x000000);
        for(int len = chars.length, w, i = 0; i < len; p += w, i++)
        {
            int rl;
            int rb;
            int rw;
            int rh;
            Glyph glyph;
            if((glyph = font.getGlyph(chars[i])) == null) glyph = font.getGlyph(0);
            if(glyph == null)
            {
                w = 0;
                continue;
            }
            w = glyph.getWidth();
            rl = glyph.getRawLeft();
            rb = glyph.getRawBottom();
            rw = glyph.getRawWidth();
            rh = glyph.getRawHeight();
            if(rw > 0 && rh > 0)
            {
                int x = p + rl;
                int y = (UnicodeRasterFont.MAX_COORDINATE + 1) - (rb + rh);
                int[] pixels = new int[rw * rh];
                glyph.getPixels(pixels, 0, rw, 0xff000000);
                render.drawRGB(pixels, 0, rw, x, y, rw, rh, true);
            }
        }
        if((s = strikeout) | (u = underline))
        {
            int lw = font.getLinesWidth();
            int ys = UnicodeRasterFont.MAX_COORDINATE - font.getStrikeoutLinePosition();
            int yu = UnicodeRasterFont.MAX_COORDINATE - font.getUnderscoreLinePosition();
            p--;
            for(int i = lw; i-- > 0; ys++, yu++)
            {
                if(s) render.drawLine(0, ys, p, ys);
                if(u) render.drawLine(0, yu, p, yu);
            }
        }
    }

    protected int getMinContentWidth() {
        return 100;
    }

    protected int getMinContentHeight() {
        return UnicodeRasterFont.MAX_COORDINATE - UnicodeRasterFont.MIN_COORDINATE + 1;
    }
}
