/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.TempoControl;
import javax.microedition.midlet.MIDlet;

public class SoundPlayer {
    static Sound explSound;
    static Sound pickSound;
    static Sound missionSound;
    static Sound bgSound;
    Player p1;

    public SoundPlayer(MIDlet mIDlet) {
        try {
            byte[] byArray = new byte[1000];
            pickSound = SoundPlayer.GameSound(mIDlet, "/pick.ott", byArray);
            explSound = SoundPlayer.GameSound(mIDlet, "/exp.ott", byArray);
            missionSound = SoundPlayer.GameSound(mIDlet, "/hit.ott", byArray);
            InputStream inputStream = this.getClass().getResourceAsStream("/Aikia.mid");
            String string = "audio/midi";
            this.p1 = Manager.createPlayer((InputStream)inputStream, (String)string);
            this.p1.realize();
            TempoControl tempoControl = (TempoControl)this.p1.getControl("TempoControl");
            tempoControl.setTempo(120000);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void playMid() {
        try {
            this.p1.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopMid() {
        try {
            this.p1.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Sound GameSound(MIDlet mIDlet, String string, byte[] byArray) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
        int n = dataInputStream.read(byArray);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        Sound sound = new Sound(byArray2, 1);
        dataInputStream.close();
        return sound;
    }

    public void stopSounds() {
        missionSound.stop();
        explSound.stop();
        pickSound.stop();
    }

    public void playExplosion() {
        explSound.setGain(100);
        this.play(explSound, 1);
    }

    public void playPickup() {
        explSound.setGain(100);
        this.play(pickSound, 1);
    }

    public void playMissionComplete() {
        this.stopSounds();
        explSound.setGain(100);
        this.play(missionSound, 1);
    }

    public void playBg() {
        explSound.setGain(100);
        this.play(bgSound, 0);
    }

    public void play(Sound sound, int n) {
        try {
            sound.setGain(100);
            if (sound.getState() != 0) {
                sound.play(n);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

